/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import net.ontopia.topicmaps.classify.AbstractDocumentAnalyzer;
import net.ontopia.topicmaps.classify.Document;
import net.ontopia.topicmaps.classify.Term;
import net.ontopia.topicmaps.classify.TextBlock;
import net.ontopia.topicmaps.classify.Token;
import net.ontopia.topicmaps.classify.Variant;

public class DistanceAnalyzer
extends AbstractDocumentAnalyzer {
    protected double high;
    protected int termCount;

    public DistanceAnalyzer() {
        super(2);
    }

    public void startDocument(Document doc) {
        super.startDocument(doc);
        if (this.iteration == 1) {
            this.high = 0.0;
        } else {
            this.termCount = 0;
        }
    }

    public void endDocument(Document doc) {
        if (this.iteration == 1) {
            this.high = Math.log(this.termCount);
        }
    }

    public void analyzeToken(TextBlock parent, Token token, int index) {
        Term term;
        double score;
        if (token.getType() != 1) {
            return;
        }
        ++this.termCount;
        if (this.iteration > 1 && (score = (term = ((Variant)token).getTerm()).getScore()) > 0.0) {
            term.addScore(this.high - Math.log(this.termCount), "distance adjustment");
        }
    }
}

