/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ontopia.topicmaps.classify.AbstractDocumentAnalyzer;
import net.ontopia.topicmaps.classify.Term;
import net.ontopia.topicmaps.classify.TermAnalyzerIF;
import net.ontopia.topicmaps.classify.TermDatabase;
import net.ontopia.topicmaps.classify.TermStemmerIF;
import net.ontopia.topicmaps.classify.TextBlock;
import net.ontopia.topicmaps.classify.Token;
import net.ontopia.topicmaps.classify.Variant;
import net.ontopia.utils.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundAnalyzer
extends AbstractDocumentAnalyzer
implements TermAnalyzerIF {
    static Logger log = LoggerFactory.getLogger((String)CompoundAnalyzer.class.getName());
    TermDatabase tdb;
    TermStemmerIF termStemmer;
    Map<Variant, Followers> followers = new HashMap<Variant, Followers>();
    int maxLength = 3;
    double term1ScoreThreshold = 0.02;
    double term2ScoreThreshold = 0.02;
    int compositeOccsThreshold = 2;
    double compoundFactor = 2.0;

    public CompoundAnalyzer() {
        super(1);
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setTerm1ScoreThreshold(double term1ScoreThreshold) {
        this.term1ScoreThreshold = term1ScoreThreshold;
    }

    public void setTerm2ScoreThreshold(double term2ScoreThreshold) {
        this.term2ScoreThreshold = term2ScoreThreshold;
    }

    public void setCompositeOccurrencesThreshold(int compositeOccsThreshold) {
        this.compositeOccsThreshold = compositeOccsThreshold;
    }

    public void setTermStemmer(TermStemmerIF stemmer) {
        this.termStemmer = stemmer;
    }

    protected void addFollower(Variant variant, Token token) {
        this.addFollower(variant, token, 1);
    }

    protected void addFollower(Variant variant, Token token, int counts) {
        Followers f = this.followers.get(variant);
        if (f == null) {
            f = new Followers();
            this.followers.put(variant, f);
        }
        f.addFollower(token, counts);
    }

    public void analyzeToken(TextBlock parent, Token token, int index) {
        List<Token> tokens;
        int size;
        if (token.getType() == 1 && (size = (tokens = parent.getTokens()).size()) - 1 > index) {
            Token next = tokens.get(index + 1);
            this.addFollower((Variant)token, next);
        }
    }

    public void analyzeTerm(Term term) {
        this.addComposites(this.tdb, term, 2);
    }

    public void startAnalysis(TermDatabase tdb) {
        this.tdb = tdb;
    }

    public void endAnalysis() {
        this.tdb = null;
    }

    public void addComposites(TermDatabase tdb, Term t1, int length) {
        double t1Score = t1.getScore();
        if (t1Score < this.term1ScoreThreshold) {
            return;
        }
        Variant[] variants = t1.getVariants();
        for (int x = 0; x < variants.length; ++x) {
            Variant v1 = variants[x];
            Followers f1 = this.followers.get(v1);
            if (f1 == null) continue;
            double limit = f1.getLimit();
            Variant[] followers1 = f1.getFollowers();
            for (int z = 0; z < followers1.length; ++z) {
                double t2Score;
                Variant v2 = followers1[z];
                Term t2 = v2.getTerm();
                if (t1.equals(t2) || (t2Score = t2.getScore()) < this.term2ScoreThreshold) continue;
                double compositeScoreTerm = f1.getScore(t2);
                int compositeOccsTerm = f1.getFollowerOccurrences(t2);
                String composite = v1.getValue() + " " + v2.getValue();
                log.debug("k:" + composite + " " + (compositeScoreTerm - limit) + ", " + compositeOccsTerm + "/" + f1.getTotalFollowerOccurences());
                if (!(compositeScoreTerm >= limit) || compositeOccsTerm < this.compositeOccsThreshold) continue;
                double compositeScore = f1.getScore(v2);
                int compositeOccs = f1.getFollowerOccurrences(v2);
                Variant v3 = tdb.createVariant(composite);
                Term t3 = v3.getTerm();
                if (t3 == null) {
                    String stem = this.termStemmer != null ? this.termStemmer.stem(composite) : composite;
                    t3 = tdb.getTerm(stem);
                    double newScore = (t1Score + t2Score * compositeScore) * this.compoundFactor;
                    if (t3 == null) {
                        t3 = tdb.createTerm(stem);
                        t3.setScore(newScore, "new compound score");
                        log.debug("c:" + t3.getStem() + " " + t3.getScore() + ", " + compositeOccs + "\n : (" + t1Score + " + (" + t2Score + " * " + compositeScore + ")) * " + this.compoundFactor + ")");
                    } else {
                        log.debug("d:" + compositeOccs + " * " + compositeScore);
                        t3.addScore(newScore, "compound adjustment");
                    }
                    v3.setTerm(t3);
                }
                t3.addVariant(v3, compositeOccs);
                Followers f2 = this.followers.get(v2);
                if (f2 != null) {
                    Variant[] followers2 = f2.getFollowers();
                    for (int y = 0; y < followers2.length; ++y) {
                        Variant v4 = followers2[y];
                        this.addFollower(v3, v4, f2.getFollowerOccurrences(v4));
                    }
                }
                log.debug("  b: " + t1.getScore() + " " + t2.getScore());
                double ns1 = 1.0 * (double)compositeOccs / (double)t1.getOccurrences();
                double ns2 = 1.0 * (double)compositeOccs / (double)t2.getOccurrences();
                if (ns1 < 1.0) {
                    t1.multiplyScore(1.0 - ns1, "compound individiual adjustment");
                }
                if (ns2 < 1.0) {
                    t2.multiplyScore(1.0 - ns2, "compound individiual adjustment");
                }
                log.debug("  a: " + t1.getScore() + " " + t2.getScore());
                if (length >= this.maxLength) continue;
                this.addComposites(tdb, t3, ++length);
            }
        }
    }

    public void dump(Term t) {
        double termScore = t.getScore();
        System.out.println("t:" + t.getPreferredName() + " " + termScore + ", " + t.getOccurrences());
        Variant[] variants = t.getVariantsByRank();
        for (int x = 0; x < variants.length; ++x) {
            Variant v = variants[x];
            System.out.println("  v:" + v + ":" + t.getOccurrences(v));
            Followers f = this.followers.get(v);
            if (f == null) {
                System.out.println("    f:null");
                continue;
            }
            System.out.println("    f:delimiters: " + f.getFollowedByDelimiter());
            Variant[] followers = f.getFollowersByRank();
            for (int z = 0; z < followers.length; ++z) {
                Variant next = followers[z];
                double nextScore = next.getTerm().getScore();
                int nextOccs = f.getFollowerOccurrences(next);
                double nextCompositeScore = f.getScore(next);
                System.out.println("    f:" + next.getValue() + " " + nextScore + ", " + nextOccs + ", " + nextCompositeScore);
            }
        }
    }

    private class Followers {
        TObjectIntHashMap<Variant> followers = new TObjectIntHashMap();
        int followedByDelimiter;
        int totalFollowerOccurrences;

        private Followers() {
        }

        public void addFollower(Token token, int counts) {
            if (token.getType() == 1) {
                Variant variant = (Variant)token;
                if (this.followers.get((Object)variant) > 0) {
                    this.followers.adjustValue((Object)variant, counts);
                } else {
                    this.followers.put((Object)variant, counts);
                }
                this.totalFollowerOccurrences += counts;
            } else {
                this.followedByDelimiter += counts;
            }
        }

        public Variant[] getFollowers() {
            return (Variant[])this.followers.keys((Object[])new Variant[this.followers.keys().length]);
        }

        public Variant[] getFollowersByRank() {
            Variant[] ranked = (Variant[])this.followers.keys((Object[])new Variant[this.followers.keys().length]);
            Arrays.sort(ranked, new CompositeScoreComparator(this));
            return ranked;
        }

        public int getTotalFollowerOccurences() {
            return this.totalFollowerOccurrences;
        }

        public int getFollowerOccurrences(Variant v) {
            return this.followers.get((Object)v);
        }

        public int getFollowerOccurrences(Term t) {
            int occs = 0;
            Variant[] variants = t.getVariants();
            for (int i = 0; i < variants.length; ++i) {
                Variant variant = variants[i];
                if (this.followers.get((Object)variant) <= 0) continue;
                occs += this.getFollowerOccurrences(variant);
            }
            return occs;
        }

        public int getFollowedByDelimiter() {
            return this.followedByDelimiter;
        }

        public double getScore(Variant v) {
            return 1.0 * (double)this.getFollowerOccurrences(v) / (double)this.totalFollowerOccurrences;
        }

        public double getScore(Term t) {
            double score = 0.0;
            Variant[] variants = t.getVariants();
            for (int i = 0; i < variants.length; ++i) {
                Variant variant = variants[i];
                if (this.followers.get((Object)variant) <= 0) continue;
                score += this.getScore(variant);
            }
            return score;
        }

        public double getLimit() {
            return 0.64 - Math.log(this.totalFollowerOccurrences) / 15.0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompositeScoreComparator
    implements Comparator<Variant> {
        Followers f;

        CompositeScoreComparator(Followers f) {
            this.f = f;
        }

        @Override
        public int compare(Variant v1, Variant v2) {
            return ObjectUtils.compare((double)this.f.getScore(v2), (double)this.f.getScore(v1));
        }
    }
}

