/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import net.ontopia.topicmaps.classify.ClassifiableContent;
import net.ontopia.topicmaps.classify.ClassifiableContentIF;
import net.ontopia.utils.OntopiaRuntimeException;
import net.ontopia.utils.StreamUtils;
import net.ontopia.utils.StringUtils;
import org.apache.commons.fileupload.DefaultFileItemFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;

public class ClassifyUtils {
    public static byte[] getContent(String file_or_url) {
        File file = new File(file_or_url);
        if (file.exists()) {
            try {
                return StreamUtils.readAndClose((InputStream)new FileInputStream(file));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ClassifiableContentIF getClassifiableContent(String file_or_url) {
        return ClassifyUtils.getClassifiableContent(ClassifyUtils.getContent(file_or_url), file_or_url);
    }

    public static ClassifiableContentIF getClassifiableContent(byte[] content) {
        return ClassifyUtils.getClassifiableContent(content, "content-" + StringUtils.md5_32((String)new String(content)));
    }

    private static ClassifiableContentIF getClassifiableContent(byte[] content, String identifier) {
        if (content != null) {
            ClassifiableContent cc = new ClassifiableContent();
            cc.setIdentifier(identifier);
            cc.setContent(content);
            return cc;
        }
        return null;
    }

    public static ClassifiableContentIF getFileUploadContent(HttpServletRequest request) {
        String contentType = request.getHeader("content-type");
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            try {
                FileUpload upload = new FileUpload((FileItemFactory)new DefaultFileItemFactory());
                for (FileItem item : upload.parseRequest(request)) {
                    if (item.getSize() <= 0L) continue;
                    byte[] content = item.get();
                    ClassifiableContent cc = new ClassifiableContent();
                    String name = item.getName();
                    if (name != null) {
                        cc.setIdentifier("fileupload:name:" + name);
                    } else {
                        cc.setIdentifier("fileupload:field:" + item.getFieldName());
                    }
                    cc.setContent(content);
                    return cc;
                }
            }
            catch (Exception e) {
                throw new OntopiaRuntimeException((Throwable)e);
            }
        }
        return null;
    }
}

