/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;
import net.ontopia.topicmaps.classify.Term;
import net.ontopia.topicmaps.classify.TermAnalyzerIF;
import net.ontopia.topicmaps.classify.TermDatabase;
import net.ontopia.utils.OntopiaRuntimeException;

public class BlackList
implements TermAnalyzerIF {
    protected Collection<String> stopList;
    protected double stopFactor = 2.0E-4;
    protected File file;
    protected Collection<String> added = new HashSet<String>();
    protected long lastModified;

    BlackList(File _file) {
        this.file = _file;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        block7: {
            if (this.file.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
                    try {
                        this.stopList = new HashSet<String>();
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            this.stopList.add(line.trim().toLowerCase());
                        }
                        this.lastModified = this.file.lastModified();
                        break block7;
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new OntopiaRuntimeException((Throwable)e);
                }
            }
            this.stopList = new HashSet<String>();
        }
    }

    public synchronized void addStopWord(String term) {
        this.added.add(term);
        this.stopList.add(term);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() {
        if (!this.added.isEmpty()) {
            try {
                boolean reload = this.file.lastModified() > this.lastModified;
                this.file.getParentFile().mkdirs();
                FileWriter writer = new FileWriter(this.file.getPath(), true);
                try {
                    for (String term : this.added) {
                        writer.write(term);
                        writer.write(10);
                    }
                }
                finally {
                    this.added.clear();
                    writer.close();
                }
                if (reload) {
                    this.load();
                }
            }
            catch (IOException e) {
                throw new OntopiaRuntimeException((Throwable)e);
            }
        }
    }

    public void setStopFactor(double stopFactor) {
        this.stopFactor = stopFactor;
    }

    public synchronized boolean isStopWord(String word) {
        return this.stopList.contains(word);
    }

    public void analyzeTerm(Term term) {
        if (this.isStopWord(term.getStem())) {
            term.multiplyScore(this.stopFactor, "blacklisted");
        }
    }

    public void startAnalysis(TermDatabase tdb) {
    }

    public void endAnalysis() {
    }
}

