/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import junit.framework.TestCase;
import net.ontopia.topicmaps.classify.ClassifiableContent;
import net.ontopia.topicmaps.classify.ClassifiableContentIF;
import net.ontopia.topicmaps.classify.FormatModuleIF;
import net.ontopia.topicmaps.classify.HTMLFormatModule;
import net.ontopia.topicmaps.classify.PDFFormatModule;
import net.ontopia.topicmaps.classify.PlainTextFormatModule;
import net.ontopia.topicmaps.classify.XMLFormatModule;

public class FormatModuleTests
extends TestCase {
    public FormatModuleTests(String name) {
        super(name);
    }

    public void testFormats() {
        XMLFormatModule xml = new XMLFormatModule();
        this.matchIdentifierTrue((FormatModuleIF)xml, "foo.xml");
        HTMLFormatModule htm = new HTMLFormatModule();
        this.matchIdentifierTrue((FormatModuleIF)htm, "foo.htm");
        this.matchIdentifierTrue((FormatModuleIF)htm, "foo.html");
        this.matchIdentifierTrue((FormatModuleIF)htm, "foo.shtml");
        this.matchIdentifierTrue((FormatModuleIF)htm, "foo.xhtml");
        PDFFormatModule pdf = new PDFFormatModule();
        this.matchIdentifierTrue((FormatModuleIF)pdf, "foo.pdf");
        PlainTextFormatModule txt = new PlainTextFormatModule();
        this.matchIdentifierTrue((FormatModuleIF)txt, "foo.txt");
    }

    protected void matchIdentifierTrue(FormatModuleIF fm, String identifier) {
        ClassifiableContent cc = new ClassifiableContent();
        cc.setIdentifier(identifier);
        cc.setContent(new byte[0]);
        FormatModuleTests.assertTrue((String)("Format module " + fm + " did not match identifier " + cc.getIdentifier()), (boolean)fm.matchesIdentifier((ClassifiableContentIF)cc));
    }
}

