/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.maven.documentation;

import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.util.TextCollectingVisitor;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.profiles.pegdown.PegdownOptionsAdapter;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;

public class Generator {
    private final Set<File> markdownFiles = new HashSet<File>();
    private final Set<File> resourceFiles = new HashSet<File>();
    private String markdownDetector = File.separator + "src" + File.separator + "site";
    private String resourceDetector = this.markdownDetector + File.separator + "resources";
    private String extension = "html";
    private Map<String, Object> conversionData = new HashMap<String, Object>();
    private File outputDir;
    private HtmlRenderer renderer;
    private Parser parser;
    private final Log log;
    private final MavenProject project;
    private File templateFile;
    private Template template;

    public Generator(MavenProject project, Log log) {
        this.project = project;
        this.log = log;
    }

    public void generate() throws MojoFailureException {
        if (this.markdownFiles != null && !this.markdownFiles.isEmpty()) {
            this.initialize();
            this.convertMarkdownFiles();
            this.copyResourceFiles();
        } else {
            this.log.info((CharSequence)"No files marked for conversion, skipping execution");
        }
    }

    private void initialize() throws MojoFailureException {
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new MojoFailureException("Could not create output directory " + this.outputDir);
        }
        MutableDataHolder options = PegdownOptionsAdapter.flexmarkOptions((int)54591479, (Extension[])new Extension[0]).toMutable();
        options.set(TablesExtension.CLASS_NAME, (Object)"table");
        this.parser = Parser.builder((DataHolder)options).build();
        this.renderer = HtmlRenderer.builder((DataHolder)options).build();
        Properties p = new Properties();
        p.put("resource.loader", "file,cp");
        p.put("cp.resource.loader.class", ClasspathResourceLoader.class.getName());
        p.put("file.resource.loader.class", FileResourceLoader.class.getName());
        p.put("file.resource.loader.path", this.templateFile.getParent());
        VelocityEngine velocity = new VelocityEngine(p);
        velocity.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.Log4JLogChute");
        velocity.setProperty("runtime.log.logsystem.log4j.logger", (Object)"velocity");
        this.template = velocity.getTemplate(this.templateFile.getName(), "utf-8");
    }

    private void convertMarkdownFiles() {
        for (File mdFile : this.markdownFiles) {
            this.log.debug((CharSequence)("Converting " + mdFile));
            this.convert(mdFile, this.getMarkdownTarget(mdFile));
        }
        this.log.info((CharSequence)("Converted " + this.markdownFiles.size() + " markdown documents"));
    }

    private void convert(File source, File target) {
        try {
            Document document = this.parser.parseReader((Reader)new FileReader(source));
            try (PrintWriter writer = new PrintWriter(new FileOutputStream(target));){
                VelocityContext c = new VelocityContext(this.conversionData);
                c.put("body", (Object)this.renderer.render((Node)document));
                c.put("title", (Object)this.findTitle((Node)document));
                c.put("root", (Object)this.getRelativeToOutput(target));
                c.put("project", (Object)this.project);
                c.put("inputFile", (Object)source);
                this.template.merge((Context)c, (Writer)writer);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not convert " + source, ioe);
        }
    }

    private String findTitle(Node root) {
        Heading h;
        if (root instanceof Heading && (h = (Heading)root).getLevel() == 1 && h.hasChildren()) {
            TextCollectingVisitor collectingVisitor = new TextCollectingVisitor();
            return collectingVisitor.collectAndGetText((Node)h);
        }
        if (root instanceof Block && root.hasChildren()) {
            for (Node child = root.getFirstChild(); child != null; child = child.getNext()) {
                String title = this.findTitle(child);
                if (title == null) continue;
                return title;
            }
        }
        return null;
    }

    private void copyResourceFiles() {
        for (File resource : this.resourceFiles) {
            try {
                this.log.debug((CharSequence)("Copying " + resource + " to " + this.getResourceTarget(resource)));
                FileUtils.copyFile((File)resource, (File)this.getResourceTarget(resource));
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not copy resource " + resource, ioe);
            }
        }
        this.log.info((CharSequence)("Copied " + this.resourceFiles.size() + " resources"));
    }

    private File getMarkdownTarget(File file) {
        String path = FilenameUtils.removeExtension((String)file.getPath());
        if (!path.contains(this.markdownDetector)) {
            throw new RuntimeException("Could not find relative path for markdown file " + file);
        }
        String relative = path.substring(path.lastIndexOf(this.markdownDetector) + this.markdownDetector.length() + 1);
        File target = new File(this.outputDir, relative + "." + this.extension);
        target.getParentFile().mkdirs();
        return target;
    }

    private File getResourceTarget(File file) {
        String path = file.getPath();
        if (!path.contains(this.resourceDetector)) {
            throw new RuntimeException("Could not find relative path for resource file " + file);
        }
        String relative = path.substring(path.lastIndexOf(this.resourceDetector) + this.resourceDetector.length() + 1);
        File target = new File(this.outputDir, relative);
        target.getParentFile().mkdirs();
        return target;
    }

    private String getRelativeToOutput(File target) {
        int depth = StringUtils.countMatches((String)target.getPath().substring(this.outputDir.getPath().length() + 1), (String)File.separator);
        String toRoot = "";
        for (int i = 0; i < depth; ++i) {
            toRoot = toRoot + "../";
        }
        return toRoot;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void addMarkdownFile(File mdFile) {
        this.markdownFiles.add(mdFile);
    }

    public void addMarkdownFiles(Collection<File> mdFiles) {
        this.markdownFiles.addAll(mdFiles);
    }

    public void addResourceFile(File resourceFile) {
        this.resourceFiles.add(resourceFile);
    }

    public void addResourceFiles(Collection<File> resourceFiles) {
        this.resourceFiles.addAll(resourceFiles);
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setMarkdownDetector(String markdownDetector) {
        this.markdownDetector = markdownDetector;
    }

    public void setResourceDetector(String resourceDetector) {
        this.resourceDetector = resourceDetector;
    }

    public void setConversionData(Map<String, Object> conversionData) {
        this.conversionData = conversionData;
    }

    public void addConversionData(String key, Object value) {
        this.conversionData.put(key, value);
    }

    public void setTemplate(File templateFile) {
        this.templateFile = templateFile;
    }
}

