/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.maven.documentation;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import net.ontopia.maven.documentation.Generator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;

@Mojo(name="generate", defaultPhase=LifecyclePhase.SITE)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(property="generate.root", defaultValue="${project.basedir}")
    private File rootDirectory;
    @Parameter(property="generate.out", defaultValue="${project.basedir}/target/site")
    private File outDirectory;
    @Parameter(property="generate.template", defaultValue="${project.basedir}/src/site/templates/distribution.vm")
    private File template;
    @Parameter(property="generate.skip", defaultValue="false")
    private boolean skip = false;
    @Parameter(property="generate.includes", defaultValue="**/*.md")
    private String[] includes;
    @Parameter(property="generate.excludes")
    private String[] excludes;
    @Parameter(property="generate.resources", defaultValue="${project.basedir}/src/site/resources")
    private File[] resources;
    @Parameter(property="generate.resourceIncludes", defaultValue="**/*")
    private String[] resourceIncludes;
    @Parameter(property="generate.resourceExcludes", defaultValue="**/.*")
    private String[] resourceExcludes;
    @Parameter(defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (this.skip) {
            log.info((CharSequence)"Skipping execution");
            return;
        }
        Generator generator = new Generator(this.project, log);
        generator.setOutputDir(this.outDirectory);
        generator.setTemplate(this.template);
        generator.addMarkdownFiles(this.collectFiles(this.rootDirectory, this.includes, this.excludes));
        generator.addResourceFiles(Arrays.asList(this.resources).parallelStream().map(resource -> this.collectFiles((File)resource, this.resourceIncludes, this.resourceExcludes)).flatMap(Collection::stream).collect(Collectors.toSet()));
        generator.generate();
    }

    private Collection<File> collectFiles(File root, String[] includes, String[] excludes) {
        if (!root.exists()) {
            return Collections.emptySet();
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(root);
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.scan();
        return Arrays.asList(scanner.getIncludedFiles()).parallelStream().map(file -> new File(root, (String)file)).collect(Collectors.toSet());
    }
}

