/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.server.servlet.test;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.net.ssl.SSLContext;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.officefloor.compile.spi.office.extension.OfficeExtensionService;
import net.officefloor.compile.spi.officefloor.extension.OfficeFloorExtensionService;
import net.officefloor.compile.test.officefloor.CompileOfficeFloor;
import net.officefloor.frame.api.source.SourceContext;
import net.officefloor.frame.test.Closure;
import net.officefloor.server.http.AbstractHttpServerImplementationTestCase;
import net.officefloor.server.http.HttpHeader;
import net.officefloor.server.http.HttpServer;
import net.officefloor.server.http.HttpServerLocation;
import net.officefloor.server.http.impl.HttpServerLocationImpl;
import net.officefloor.server.servlet.test.MockServerSettings;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public abstract class AbstractServletHttpServerImplementationTest
extends AbstractHttpServerImplementationTestCase {
    public static Server createServer(HttpServerLocation serverLocation, SSLContext sslContext) {
        Server server = new Server();
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>(2);
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(serverLocation.getHttpPort());
        connectors.add(connector);
        int httpsPort = serverLocation.getHttpsPort();
        if (httpsPort > 0) {
            HttpConfiguration https = new HttpConfiguration();
            https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setSslContext(sslContext);
            sslContextFactory.setExcludeCipherSuites(new String[0]);
            sslContextFactory.setExcludeProtocols(new String[0]);
            ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, "http/1.1"), new HttpConnectionFactory(https)});
            sslConnector.setPort(httpsPort);
            connectors.add(sslConnector);
        }
        server.setConnectors((Connector[])connectors.toArray(new ServerConnector[connectors.size()]));
        return server;
    }

    protected abstract void configureServer(ServerContext var1) throws Exception;

    protected AutoCloseable startHttpServer(OfficeFloorExtensionService officeFloorExtension, OfficeExtensionService officeExtension) throws Exception {
        Closure location = new Closure();
        Closure sslContext = new Closure();
        CompileOfficeFloor locationCompiler = new CompileOfficeFloor();
        locationCompiler.officeFloor(context -> {
            location.value = new HttpServerLocationImpl((SourceContext)context.getOfficeFloorSourceContext());
            sslContext.value = HttpServer.getSslContext((SourceContext)context.getOfficeFloorSourceContext());
        });
        locationCompiler.compileAndOpenOfficeFloor().close();
        Server server = AbstractServletHttpServerImplementationTest.createServer((HttpServerLocation)location.value, (SSLContext)sslContext.value);
        ServletContextHandler handler = new ServletContextHandler();
        handler.addFilter(new FilterHolder((Filter)new FixHeadersFilter(this.getServerName())), "/*", EnumSet.of(DispatcherType.REQUEST));
        server.setHandler((Handler)handler);
        MockServerSettings.runWithinContext(officeFloorExtension, officeExtension, () -> {
            this.configureServer(new ServerContext(server, handler));
            server.start();
        });
        return () -> server.stop();
    }

    protected AutoCloseable startRawHttpServer(HttpServerLocation serverLocation) throws Exception {
        Server server = AbstractServletHttpServerImplementationTest.createServer(serverLocation, null);
        final FixHeadersFilter fixHeaders = new FixHeadersFilter(this.getServerName());
        final byte[] helloWorld = "hello world".getBytes(Charset.forName("UTF-8"));
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                response.setStatus(200);
                fixHeaders.loadFixHeaders(response);
                response.setContentType("text/plain");
                response.getOutputStream().write(helloWorld);
                baseRequest.setHandled(true);
            }
        });
        server.start();
        return () -> server.stop();
    }

    protected HttpHeader[] getServerResponseHeaderValues() {
        return new HttpHeader[]{AbstractServletHttpServerImplementationTest.newHttpHeader((String)"Date", (String)"NOW"), AbstractServletHttpServerImplementationTest.newHttpHeader((String)"Server", (String)this.getServerName()), AbstractServletHttpServerImplementationTest.newHttpHeader((String)"Expires", (String)"Thu, 01 Jan 1970 00:00:00 GMT"), AbstractServletHttpServerImplementationTest.newHttpHeader((String)"Content-Type", (String)"text/plain"), AbstractServletHttpServerImplementationTest.newHttpHeader((String)"Content-Length", (String)"?")};
    }

    protected boolean isHandleCancel() {
        return false;
    }

    public static class FixHeadersFilter
    extends HttpFilter {
        private static final long serialVersionUID = 1L;
        private final String serverName;

        private FixHeadersFilter(String serverName) {
            this.serverName = serverName;
        }

        protected void loadFixHeaders(HttpServletResponse response) {
            response.setHeader("Date", "NOW");
            response.setHeader("Server", this.serverName);
            response.setHeader("Expires", "Thu, 01 Jan 1970 00:00:00 GMT");
        }

        protected void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
            this.loadFixHeaders(res);
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
    }

    protected static class ServerContext {
        private final Server server;
        private final ServletContextHandler handler;

        private ServerContext(Server server, ServletContextHandler handler) {
            this.server = server;
            this.handler = handler;
        }

        public Server getServer() {
            return this.server;
        }

        public ServletContextHandler getHandler() {
            return this.handler;
        }
    }
}

