/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.server.http.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.officefloor.server.http.HttpException;
import net.officefloor.server.stream.impl.ByteSequence;

public class HttpServletEntityByteSequence
implements ByteSequence {
    private final HttpServletRequest request;
    private volatile byte[] bytes;

    public HttpServletEntityByteSequence(HttpServletRequest request) {
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureBytesLoaded() {
        block6: {
            try {
                if (this.bytes != null) break block6;
                HttpServletRequest httpServletRequest = this.request;
                synchronized (httpServletRequest) {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    ServletInputStream requestEntity = this.request.getInputStream();
                    int value = requestEntity.read();
                    while (value != -1) {
                        buffer.write(value);
                        value = requestEntity.read();
                    }
                    this.bytes = buffer.toByteArray();
                }
            }
            catch (IOException ex) {
                throw new HttpException((Throwable)ex);
            }
        }
    }

    public byte byteAt(int index) {
        this.ensureBytesLoaded();
        return this.bytes[index];
    }

    public int length() {
        this.ensureBytesLoaded();
        return this.bytes.length;
    }
}

