/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.server.http.servlet;

import net.officefloor.compile.spi.office.OfficeArchitect;
import net.officefloor.compile.spi.office.extension.OfficeExtensionContext;
import net.officefloor.compile.spi.office.extension.OfficeExtensionService;
import net.officefloor.compile.spi.officefloor.DeployedOffice;
import net.officefloor.compile.spi.officefloor.ExternalServiceInput;
import net.officefloor.compile.spi.officefloor.OfficeFloorDeployer;
import net.officefloor.compile.spi.officefloor.OfficeFloorResponsibility;
import net.officefloor.compile.spi.officefloor.OfficeFloorTeam;
import net.officefloor.frame.api.team.source.TeamSource;
import net.officefloor.frame.impl.spi.team.ThreadLocalAwareTeamSource;
import net.officefloor.server.http.HttpServerImplementation;
import net.officefloor.server.http.HttpServerImplementationContext;
import net.officefloor.server.http.HttpServerLocation;
import net.officefloor.server.http.ServerHttpConnection;
import net.officefloor.server.http.impl.ProcessAwareServerHttpConnectionManagedObject;
import net.officefloor.server.http.servlet.HttpServletOfficeFloorBridge;

public class HttpServletHttpServerImplementation
implements HttpServerImplementation,
OfficeExtensionService {
    private static final ThreadLocal<Bridge> threadLocalBridge = new ThreadLocal();
    private static final String SYNC_TEAM_NAME = "_servlet_sync_team_";

    public static HttpServletOfficeFloorBridge load(HttpServletOfficeFloorLoader loader) throws Exception {
        Bridge bridge = new Bridge();
        try {
            threadLocalBridge.set(bridge);
            loader.load();
            HttpServletOfficeFloorBridge httpServletOfficeFloorBridge = bridge.bridge;
            return httpServletOfficeFloorBridge;
        }
        finally {
            threadLocalBridge.set(null);
        }
    }

    public void configureHttpServer(HttpServerImplementationContext context) {
        Bridge bridge = threadLocalBridge.get();
        if (bridge == null) {
            throw new IllegalStateException("Must load " + this.getClass().getSimpleName() + " within load context");
        }
        HttpServerLocation location = context.getHttpServerLocation();
        boolean isIncludeEscalationStackTrace = context.isIncludeEscalationStackTrace();
        ExternalServiceInput input = context.getExternalServiceInput(ProcessAwareServerHttpConnectionManagedObject.class, ProcessAwareServerHttpConnectionManagedObject.getCleanupEscalationHandler());
        bridge.bridge = new HttpServletOfficeFloorBridge(location, isIncludeEscalationStackTrace, (ExternalServiceInput<ServerHttpConnection, ProcessAwareServerHttpConnectionManagedObject>)input);
        OfficeFloorDeployer deployer = context.getOfficeFloorDeployer();
        OfficeFloorTeam team = deployer.addTeam(SYNC_TEAM_NAME, (TeamSource)new ThreadLocalAwareTeamSource());
        DeployedOffice office = deployer.getDeployedOffice("OFFICE");
        deployer.link((OfficeFloorResponsibility)office.getDeployedOfficeTeam(SYNC_TEAM_NAME), team);
    }

    public void extendOffice(OfficeArchitect officeArchitect, OfficeExtensionContext context) throws Exception {
        officeArchitect.addOfficeTeam(SYNC_TEAM_NAME);
    }

    private static class Bridge {
        private HttpServletOfficeFloorBridge bridge = null;

        private Bridge() {
        }
    }

    @FunctionalInterface
    public static interface HttpServletOfficeFloorLoader {
        public void load() throws Exception;
    }
}

