/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.server.http.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.officefloor.server.http.HttpException;
import net.officefloor.server.stream.impl.ByteSequence;

public class HttpServletEntityByteSequence
implements ByteSequence {
    private final HttpServletRequest request;
    private byte[] bytes;

    public HttpServletEntityByteSequence(HttpServletRequest request) throws IOException {
        this.request = request;
    }

    private void ensureBytesLoaded() {
        if (this.bytes != null) {
            return;
        }
        try {
            ServletInputStream requestEntity = this.request.getInputStream();
            int bytesRead = 0;
            byte[] transfer = new byte[1024];
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            do {
                if ((bytesRead = requestEntity.read(transfer)) <= 0) continue;
                buffer.write(transfer, 0, bytesRead);
            } while (bytesRead == transfer.length);
            this.bytes = buffer.toByteArray();
        }
        catch (IOException ex) {
            throw new HttpException((Throwable)ex);
        }
    }

    public byte byteAt(int index) {
        this.ensureBytesLoaded();
        return this.bytes[index];
    }

    public int length() {
        this.ensureBytesLoaded();
        return this.bytes.length;
    }
}

