/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.server.http.servlet;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.officefloor.compile.OfficeFloorCompiler;
import net.officefloor.frame.api.manage.OfficeFloor;
import net.officefloor.frame.api.managedobject.ManagedObject;
import net.officefloor.server.http.HttpMethod;
import net.officefloor.server.http.HttpResponseWriter;
import net.officefloor.server.http.HttpVersion;
import net.officefloor.server.http.impl.NonMaterialisedHttpHeaders;
import net.officefloor.server.http.impl.ProcessAwareServerHttpConnectionManagedObject;
import net.officefloor.server.http.servlet.HttpServletEntityByteSequence;
import net.officefloor.server.http.servlet.HttpServletHttpResponseWriter;
import net.officefloor.server.http.servlet.HttpServletHttpServerImplementation;
import net.officefloor.server.http.servlet.HttpServletNonMaterialisedHttpHeaders;
import net.officefloor.server.http.servlet.HttpServletOfficeFloorBridge;
import net.officefloor.server.stream.StreamBufferPool;
import net.officefloor.server.stream.impl.ByteSequence;
import net.officefloor.server.stream.impl.ThreadLocalStreamBufferPool;

public class OfficeFloorFilter
implements Filter {
    private static final StreamBufferPool<ByteBuffer> bufferPool = new ThreadLocalStreamBufferPool(() -> ByteBuffer.allocate(1024), 10, 1000);
    private FilterConfig filterConfig;
    private OfficeFloor officeFloor;
    private volatile HttpServletOfficeFloorBridge bridge;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        try {
            this.bridge = HttpServletHttpServerImplementation.load(() -> {
                OfficeFloorCompiler compiler = OfficeFloorCompiler.newOfficeFloorCompiler(null);
                this.officeFloor = compiler.compile("OfficeFloor");
                this.officeFloor.openOfficeFloor();
            });
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void destroy() {
        if (this.officeFloor != null) {
            try {
                this.officeFloor.close();
            }
            catch (Exception ex) {
                this.filterConfig.getServletContext().log("Failed to close OfficeFloor", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletHttpResponseWriter writer;
        HttpServletEntityByteSequence entity;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpServletNonMaterialisedHttpHeaders httpHeaders = new HttpServletNonMaterialisedHttpHeaders(httpRequest);
        HttpServletRequest httpServletRequest = httpRequest;
        synchronized (httpServletRequest) {
            entity = new HttpServletEntityByteSequence(httpRequest);
        }
        HttpServletResponse httpServletResponse = httpResponse;
        synchronized (httpServletResponse) {
            writer = new HttpServletHttpResponseWriter(httpResponse, bufferPool);
        }
        HttpMethod httpMethod = HttpMethod.getHttpMethod((String)httpRequest.getMethod());
        String requestUri = httpRequest.getRequestURI() + (httpRequest.getQueryString() != null ? "?" + httpRequest.getQueryString() : "");
        ProcessAwareServerHttpConnectionManagedObject connection = new ProcessAwareServerHttpConnectionManagedObject(this.bridge.getHttpServerLocation(), httpRequest.isSecure(), () -> httpMethod, () -> requestUri, HttpVersion.getHttpVersion((String)request.getProtocol()), (NonMaterialisedHttpHeaders)httpHeaders, (ByteSequence)entity, null, null, this.bridge.isIncludeEscalationStackTrace(), (HttpResponseWriter)writer, bufferPool);
        this.bridge.getInput().service((ManagedObject)connection, connection.getServiceFlowCallback());
        if (!writer.isServiced()) {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }
}

