/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.server.http.servlet;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import net.officefloor.server.http.HttpHeaderValue;
import net.officefloor.server.http.HttpResponseWriter;
import net.officefloor.server.http.HttpStatus;
import net.officefloor.server.http.HttpVersion;
import net.officefloor.server.http.WritableHttpCookie;
import net.officefloor.server.http.WritableHttpHeader;
import net.officefloor.server.stream.BufferJvmFix;
import net.officefloor.server.stream.StreamBuffer;
import net.officefloor.server.stream.StreamBufferPool;

public class HttpServletHttpResponseWriter
implements HttpResponseWriter<ByteBuffer> {
    private static final ByteBufferWriter byteBufferWriter = (buffer, outputStream) -> {
        for (int position = BufferJvmFix.position((Buffer)buffer); position < buffer.limit(); ++position) {
            outputStream.write((int)buffer.get());
        }
    };
    private final HttpServletResponse response;
    private final StreamBufferPool<ByteBuffer> bufferPool;
    private boolean isServiced = false;
    private IOException failure = null;

    public HttpServletHttpResponseWriter(HttpServletResponse response, StreamBufferPool<ByteBuffer> bufferPool) {
        this.response = response;
        this.bufferPool = bufferPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isServiced() throws IOException {
        HttpServletResponse httpServletResponse = this.response;
        synchronized (httpServletResponse) {
            if (this.failure != null) {
                throw this.failure;
            }
            return this.isServiced;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHttpResponse(HttpVersion version, HttpStatus status, WritableHttpHeader headHttpHeader, WritableHttpCookie headHttpCookie, long contentLength, HttpHeaderValue contentType, StreamBuffer<ByteBuffer> contentHeadStreamBuffer) {
        switch (status.getStatusCode()) {
            case 404: 
            case 405: {
                return;
            }
        }
        HttpServletResponse httpServletResponse = this.response;
        synchronized (httpServletResponse) {
            this.isServiced = true;
            this.response.setStatus(status.getStatusCode());
            WritableHttpHeader header = headHttpHeader;
            while (header != null) {
                this.response.setHeader(header.getName(), header.getValue());
                header = header.next;
            }
            WritableHttpCookie cookie = headHttpCookie;
            while (cookie != null) {
                this.response.addCookie(new Cookie(headHttpCookie.getName(), headHttpCookie.getValue()));
                cookie = cookie.next;
            }
            if (contentType != null) {
                this.response.setContentType(contentType.getValue());
            }
            try {
                ServletOutputStream entity = this.response.getOutputStream();
                StreamBuffer stream = contentHeadStreamBuffer;
                while (stream != null) {
                    if (stream.pooledBuffer != null) {
                        BufferJvmFix.flip((Buffer)((Buffer)stream.pooledBuffer));
                        byteBufferWriter.write((ByteBuffer)stream.pooledBuffer, entity);
                    } else if (stream.unpooledByteBuffer != null) {
                        byteBufferWriter.write(stream.unpooledByteBuffer, entity);
                    } else {
                        StreamBuffer streamBuffer = this.bufferPool.getPooledStreamBuffer();
                        boolean isWritten = false;
                        try {
                            int bytesRead;
                            ByteBuffer buffer = (ByteBuffer)streamBuffer.pooledBuffer;
                            long position = stream.fileBuffer.position;
                            long count = stream.fileBuffer.count;
                            do {
                                BufferJvmFix.clear((Buffer)buffer);
                                bytesRead = stream.fileBuffer.file.read(buffer, position);
                                position += (long)bytesRead;
                                BufferJvmFix.flip((Buffer)buffer);
                                if (count >= 0L && (count -= (long)bytesRead) < 0L) {
                                    buffer.limit(buffer.limit() - (int)Math.abs(count));
                                    bytesRead = 0;
                                }
                                byteBufferWriter.write(buffer, entity);
                            } while (bytesRead > 0);
                            isWritten = true;
                        }
                        finally {
                            streamBuffer.release();
                            if (stream.fileBuffer.callback != null) {
                                stream.fileBuffer.callback.complete(stream.fileBuffer.file, isWritten);
                            }
                        }
                    }
                    stream = stream.next;
                }
            }
            catch (IOException ex) {
                this.failure = ex;
            }
        }
    }

    @FunctionalInterface
    private static interface ByteBufferWriter {
        public void write(ByteBuffer var1, ServletOutputStream var2) throws IOException;
    }
}

