/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.webxml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import net.officefloor.compile.spi.section.ManagedObjectDependency;
import net.officefloor.compile.spi.section.SectionDesigner;
import net.officefloor.compile.spi.section.SectionInput;
import net.officefloor.compile.spi.section.SectionManagedObject;
import net.officefloor.compile.spi.section.SectionManagedObjectSource;
import net.officefloor.compile.spi.section.SectionObject;
import net.officefloor.compile.spi.section.SectionOutput;
import net.officefloor.compile.spi.section.SectionTask;
import net.officefloor.compile.spi.section.SectionWork;
import net.officefloor.compile.spi.section.source.SectionSourceContext;
import net.officefloor.compile.spi.section.source.impl.AbstractSectionSource;
import net.officefloor.frame.api.build.OfficeFloorIssues;
import net.officefloor.frame.internal.structure.FlowInstigationStrategyEnum;
import net.officefloor.frame.internal.structure.ManagedObjectScope;
import net.officefloor.frame.spi.source.SourceContext;
import net.officefloor.plugin.servlet.container.source.HttpServletTask;
import net.officefloor.plugin.servlet.container.source.HttpServletWorkSource;
import net.officefloor.plugin.servlet.context.source.OfficeServletContextManagedObjectSource;
import net.officefloor.plugin.servlet.host.ServletServer;
import net.officefloor.plugin.servlet.route.ServletRouteTask;
import net.officefloor.plugin.servlet.route.source.ServletRouteWorkSource;
import net.officefloor.plugin.servlet.security.HttpServletSecurity;
import net.officefloor.plugin.servlet.webxml.InvalidServletConfigurationException;
import net.officefloor.plugin.servlet.webxml.model.ContextParamModel;
import net.officefloor.plugin.servlet.webxml.model.FilterMappingModel;
import net.officefloor.plugin.servlet.webxml.model.FilterModel;
import net.officefloor.plugin.servlet.webxml.model.InitParamModel;
import net.officefloor.plugin.servlet.webxml.model.MimeMappingModel;
import net.officefloor.plugin.servlet.webxml.model.ServletMappingModel;
import net.officefloor.plugin.servlet.webxml.model.ServletModel;
import net.officefloor.plugin.servlet.webxml.model.WebAppModel;
import net.officefloor.plugin.servlet.webxml.model.WebXmlLoader;
import net.officefloor.plugin.socket.server.http.ServerHttpConnection;
import net.officefloor.plugin.web.http.application.HttpRequestState;
import net.officefloor.plugin.web.http.session.HttpSession;

public class WebXmlSectionSource
extends AbstractSectionSource {
    public static final String PROPERTY_WEB_XML_CONFIGURATION = "web.xml.configuration";
    public static final String SERVICE_INPUT = "service";
    public static final String UNHANDLED_OUTPUT = "unhandled";

    public static void validateWebXmlConfiguration(InputStream webXmlContents, SourceContext context) throws InvalidServletConfigurationException {
        WebAppModel webApp;
        try {
            webApp = new WebXmlLoader().loadConfiguration(webXmlContents, context);
        }
        catch (Exception ex) {
            throw new InvalidServletConfigurationException("Invalid web.xml configuration [" + ex.getClass().getSimpleName() + "]: " + ex.getMessage());
        }
        if (webApp.getServlets().size() == 0) {
            throw new InvalidServletConfigurationException("Must have at least one servlet configured");
        }
        if (webApp.getServletMappings().size() == 0) {
            throw new InvalidServletConfigurationException("Must have at least one servlet-mapping configured");
        }
    }

    protected void loadSpecification(AbstractSectionSource.SpecificationContext context) {
    }

    public void sourceSection(SectionDesigner designer, SectionSourceContext context) throws Exception {
        InputStream webXmlConfiguration;
        String webXmlLocation = context.getSectionLocation();
        if (webXmlLocation != null) {
            webXmlConfiguration = context.getResource(webXmlLocation);
        } else {
            String webXmlContent = context.getProperty(PROPERTY_WEB_XML_CONFIGURATION);
            webXmlConfiguration = new ByteArrayInputStream(webXmlContent.getBytes());
        }
        WebAppModel webApp = new WebXmlLoader().loadConfiguration(webXmlConfiguration, (SourceContext)context);
        SectionInput serviceInput = designer.addSectionInput(SERVICE_INPUT, null);
        SectionOutput unhandledOutput = designer.addSectionOutput(UNHANDLED_OUTPUT, null, false);
        SectionOutput servletExceptionOutput = designer.addSectionOutput(ServletException.class.getSimpleName(), ServletException.class.getName(), true);
        SectionOutput ioExceptionOutput = designer.addSectionOutput(IOException.class.getSimpleName(), IOException.class.getName(), true);
        SectionObject servletServerMo = designer.addSectionObject("SERVLET_SERVER", ServletServer.class.getName());
        SectionObject httpConnectionMo = designer.addSectionObject("HTTP_CONNECTION", ServerHttpConnection.class.getName());
        SectionObject requestAttributesMo = designer.addSectionObject("REQUEST_ATTRIBUTES", HttpRequestState.class.getName());
        SectionObject httpSessionMo = designer.addSectionObject("HTTP_SESSION", HttpSession.class.getName());
        SectionObject httpSecurityMo = designer.addSectionObject("HTTP_SECURITY", HttpServletSecurity.class.getName());
        String servletContextName = webApp.getDisplayName() == null ? "OfficeFloor" : webApp.getDisplayName();
        SectionManagedObjectSource officeServletContextMos = designer.addSectionManagedObjectSource("OfficeServletContext", OfficeServletContextManagedObjectSource.class.getName());
        officeServletContextMos.addProperty("servlet.context.name", servletContextName);
        for (ContextParamModel contextParam : webApp.getContextParams()) {
            officeServletContextMos.addProperty("init.parameter." + contextParam.getName(), contextParam.getValue());
        }
        SectionManagedObject officeServletContextMo = officeServletContextMos.addSectionManagedObject("OfficeServletContext", ManagedObjectScope.PROCESS);
        ManagedObjectDependency contextToServerDependency = officeServletContextMo.getManagedObjectDependency("SERVLET_SERVER");
        designer.link(contextToServerDependency, servletServerMo);
        for (MimeMappingModel mimeMapping : webApp.getMimeMappings()) {
            officeServletContextMos.addProperty("file.ext.to.mime.type." + mimeMapping.getExtension(), mimeMapping.getMimeType());
        }
        for (FilterModel filter : webApp.getFilters()) {
            String filterName = filter.getFilterName();
            String filterClass = filter.getFilterClass().trim();
            officeServletContextMos.addProperty("filter.instance.name." + filterName, filterClass);
            for (InitParamModel initParam : filter.getInitParams()) {
                officeServletContextMos.addProperty("filter.instance.init." + filterName + "." + initParam.getName(), initParam.getValue());
            }
        }
        int filterMappingIndex = 0;
        for (FilterMappingModel filterMapping : webApp.getFilterMappings()) {
            String index;
            String filterName = filterMapping.getFilterName();
            String dispatchers = null;
            for (String dispatcher : filterMapping.getDispatchers()) {
                dispatchers = (dispatchers == null ? "" : dispatchers + ",") + dispatcher;
            }
            for (String urlPattern : filterMapping.getUrlPatterns()) {
                index = String.valueOf(filterMappingIndex++);
                officeServletContextMos.addProperty("filter.mapping.index." + index, filterName);
                officeServletContextMos.addProperty("filter.mapping.url." + index, urlPattern);
                if (dispatchers == null) continue;
                officeServletContextMos.addProperty("filter.mapping.type." + index, dispatchers);
            }
            for (String servletName : filterMapping.getServletNames()) {
                index = String.valueOf(filterMappingIndex++);
                officeServletContextMos.addProperty("filter.mapping.index." + index, filterName);
                officeServletContextMos.addProperty("filter.mapping.servlet." + index, servletName);
                if (dispatchers == null) continue;
                officeServletContextMos.addProperty("filter.mapping.type." + index, dispatchers);
            }
        }
        SectionWork routeWork = designer.addSectionWork("Route", ServletRouteWorkSource.class.getName());
        SectionTask routeTask = routeWork.addSectionTask("route", "route");
        designer.link(serviceInput, routeTask);
        designer.link(routeTask.getTaskFlow(ServletRouteTask.FlowKeys.UNHANDLED.name()), unhandledOutput, FlowInstigationStrategyEnum.SEQUENTIAL);
        designer.link(routeTask.getTaskObject(ServletRouteTask.DependencyKeys.HTTP_CONNECTION.name()), httpConnectionMo);
        designer.link(routeTask.getTaskObject(ServletRouteTask.DependencyKeys.OFFICE_SERVLET_CONTEXT.name()), officeServletContextMo);
        HashMap<String, String> servletMappings = new HashMap<String, String>();
        List<ServletMappingModel> servletMappingModels = webApp.getServletMappings();
        if (servletMappingModels.size() == 0) {
            designer.addIssue("At least one <servlet-mapping/> element must be configured", OfficeFloorIssues.AssetType.WORK, "servlet-mapping");
        }
        for (ServletMappingModel mappingModel : servletMappingModels) {
            String servletName = mappingModel.getServletName();
            String urlPatterns = (String)servletMappings.get(servletName);
            for (String pattern : mappingModel.getUrlPatterns()) {
                urlPatterns = (urlPatterns == null ? "" : urlPatterns + ",") + pattern;
            }
            servletMappings.put(servletName, urlPatterns);
        }
        List<ServletModel> servletModels = webApp.getServlets();
        if (servletModels.size() == 0) {
            designer.addIssue("At least one <servlet/> element must be configured", OfficeFloorIssues.AssetType.WORK, "servlet");
        }
        for (ServletModel servletModel : servletModels) {
            String servletName = servletModel.getServletName();
            String servletClass = servletModel.getServletClass().trim();
            String servletUrlPatterns = (String)servletMappings.get(servletName);
            SectionWork servlet = designer.addSectionWork(servletName, HttpServletWorkSource.class.getName());
            servlet.addProperty("servlet.name", servletName);
            servlet.addProperty("http.servlet.class.name", servletClass);
            servlet.addProperty("servlet.mappings", servletUrlPatterns);
            for (InitParamModel initParam : servletModel.getInitParams()) {
                servlet.addProperty("init.parameter." + initParam.getName(), initParam.getValue());
            }
            SectionTask servletTask = servlet.addSectionTask("service-by-" + servletName, SERVICE_INPUT);
            servletTask.getTaskObject(HttpServletTask.DependencyKeys.SERVICER_MAPPING.name()).flagAsParameter();
            designer.link(servletTask.getTaskObject(HttpServletTask.DependencyKeys.OFFICE_SERVLET_CONTEXT.name()), officeServletContextMo);
            designer.link(servletTask.getTaskObject(HttpServletTask.DependencyKeys.HTTP_CONNECTION.name()), httpConnectionMo);
            designer.link(servletTask.getTaskObject(HttpServletTask.DependencyKeys.REQUEST_ATTRIBUTES.name()), requestAttributesMo);
            designer.link(servletTask.getTaskObject(HttpServletTask.DependencyKeys.HTTP_SESSION.name()), httpSessionMo);
            designer.link(servletTask.getTaskObject(HttpServletTask.DependencyKeys.HTTP_SECURITY.name()), httpSecurityMo);
            designer.link(servletTask.getTaskEscalation(ServletException.class.getName()), servletExceptionOutput, FlowInstigationStrategyEnum.SEQUENTIAL);
            designer.link(servletTask.getTaskEscalation(IOException.class.getName()), ioExceptionOutput, FlowInstigationStrategyEnum.SEQUENTIAL);
        }
    }
}

