/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.web.http.application;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.spi.managedobject.CoordinatingManagedObject;
import net.officefloor.frame.spi.managedobject.ManagedObject;
import net.officefloor.frame.spi.managedobject.ObjectRegistry;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractAsyncManagedObjectSource;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractManagedObjectSource;
import net.officefloor.plugin.servlet.bridge.ServletBridge;
import net.officefloor.plugin.web.http.application.HttpRequestState;

public class ServletHttpRequestStateManagedObjectSource
extends AbstractManagedObjectSource<Dependencies, None> {
    protected void loadSpecification(AbstractAsyncManagedObjectSource.SpecificationContext context) {
    }

    protected void loadMetaData(AbstractAsyncManagedObjectSource.MetaDataContext<Dependencies, None> context) throws Exception {
        context.setObjectClass(HttpRequestState.class);
        context.setManagedObjectClass(ServletHttpRequestStateManagedObject.class);
        context.addDependency((Enum)Dependencies.SERVLET_BRIDGE, ServletBridge.class);
    }

    protected ManagedObject getManagedObject() throws Throwable {
        return new ServletHttpRequestStateManagedObject();
    }

    private static class AttributeStateMomento
    implements Serializable {
        private final String name;
        private final Serializable value;

        public AttributeStateMomento(String name, Serializable value) {
            this.name = name;
            this.value = value;
        }
    }

    private static class StateMomento
    implements Serializable {
        private final List<AttributeStateMomento> attributes;

        public StateMomento(List<AttributeStateMomento> attributes) {
            this.attributes = attributes;
        }
    }

    public static class ServletHttpRequestStateManagedObject
    implements CoordinatingManagedObject<Dependencies>,
    HttpRequestState {
        private HttpServletRequest request;

        public void loadObjects(ObjectRegistry<Dependencies> registry) throws Throwable {
            ServletBridge bridge = (ServletBridge)registry.getObject((Enum)Dependencies.SERVLET_BRIDGE);
            this.request = bridge.getRequest();
        }

        public Object getObject() throws Throwable {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Serializable getAttribute(String name) {
            HttpServletRequest httpServletRequest = this.request;
            synchronized (httpServletRequest) {
                return (Serializable)this.request.getAttribute(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator<String> getAttributeNames() {
            HttpServletRequest httpServletRequest = this.request;
            synchronized (httpServletRequest) {
                ArrayList list = new ArrayList();
                Enumeration names = this.request.getAttributeNames();
                while (names.hasMoreElements()) {
                    list.add(names.nextElement());
                }
                return list.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAttribute(String name, Serializable object) {
            HttpServletRequest httpServletRequest = this.request;
            synchronized (httpServletRequest) {
                this.request.setAttribute(name, (Object)object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAttribute(String name) {
            HttpServletRequest httpServletRequest = this.request;
            synchronized (httpServletRequest) {
                this.request.removeAttribute(name);
            }
        }

        public Serializable exportState() throws IOException {
            LinkedList<AttributeStateMomento> attributes = new LinkedList<AttributeStateMomento>();
            Enumeration names = this.request.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Serializable value = (Serializable)this.request.getAttribute(name);
                attributes.add(new AttributeStateMomento(name, value));
            }
            return new StateMomento(attributes);
        }

        public void importState(Serializable momento) throws IOException, IllegalArgumentException {
            StateMomento state = (StateMomento)momento;
            for (AttributeStateMomento attribute : state.attributes) {
                this.request.setAttribute(attribute.name, (Object)attribute.value);
            }
        }
    }

    public static enum Dependencies {
        SERVLET_BRIDGE;

    }
}

