/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.security;

import java.security.Principal;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.spi.managedobject.AsynchronousListener;
import net.officefloor.frame.spi.managedobject.AsynchronousManagedObject;
import net.officefloor.frame.spi.managedobject.CoordinatingManagedObject;
import net.officefloor.frame.spi.managedobject.ManagedObject;
import net.officefloor.frame.spi.managedobject.ObjectRegistry;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractAsyncManagedObjectSource;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractManagedObjectSource;
import net.officefloor.plugin.servlet.security.HttpServletSecurity;
import net.officefloor.plugin.web.http.security.HttpAuthenticateRequest;
import net.officefloor.plugin.web.http.security.HttpAuthentication;
import net.officefloor.plugin.web.http.security.HttpSecurity;

public class HttpServletSecurityManagedObjectSource
extends AbstractManagedObjectSource<Dependencies, None> {
    protected void loadSpecification(AbstractAsyncManagedObjectSource.SpecificationContext context) {
    }

    protected void loadMetaData(AbstractAsyncManagedObjectSource.MetaDataContext<Dependencies, None> context) throws Exception {
        context.setObjectClass(HttpServletSecurity.class);
        context.setManagedObjectClass(HttpSecurityManagedObject.class);
        context.addDependency((Enum)Dependencies.HTTP_AUTHENTICATION, HttpAuthentication.class);
    }

    protected ManagedObject getManagedObject() throws Throwable {
        return new HttpSecurityManagedObject();
    }

    private static class HttpServletSecurityImpl
    implements HttpServletSecurity {
        private final HttpSecurity security;

        public HttpServletSecurityImpl(HttpSecurity security) {
            this.security = security;
        }

        @Override
        public String getAuthenticationScheme() {
            return this.security == null ? null : this.security.getAuthenticationScheme();
        }

        @Override
        public Principal getUserPrincipal() {
            return this.security == null ? null : this.security.getUserPrincipal();
        }

        @Override
        public String getRemoteUser() {
            return this.security == null ? null : this.security.getRemoteUser();
        }

        @Override
        public boolean isUserInRole(String role) {
            return this.security == null ? null : Boolean.valueOf(this.security.isUserInRole(role));
        }
    }

    private static class HttpAuthenticateRequestImpl<S, C>
    implements HttpAuthenticateRequest<C> {
        private final HttpSecurityManagedObject<S, C> managedObject;

        public HttpAuthenticateRequestImpl(HttpSecurityManagedObject<S, C> managedObject) {
            this.managedObject = managedObject;
        }

        public C getCredentials() {
            return null;
        }

        public void authenticationComplete() {
            ((HttpSecurityManagedObject)this.managedObject).flagAuthenticationComplete();
        }
    }

    public static class HttpSecurityManagedObject<S, C>
    implements AsynchronousManagedObject,
    CoordinatingManagedObject<Dependencies> {
        private AsynchronousListener listener;
        private HttpAuthentication<S, C> authentication;

        private synchronized void flagAuthenticationComplete() {
            this.listener.notifyComplete();
        }

        public void registerAsynchronousCompletionListener(AsynchronousListener listener) {
            this.listener = listener;
        }

        public synchronized void loadObjects(ObjectRegistry<Dependencies> registry) throws Throwable {
            this.authentication = (HttpAuthentication)registry.getObject((Enum)Dependencies.HTTP_AUTHENTICATION);
            this.listener.notifyStarted();
            this.authentication.authenticate(new HttpAuthenticateRequestImpl(this));
        }

        public Object getObject() throws Throwable {
            HttpSecurity security = (HttpSecurity)this.authentication.getHttpSecurity();
            if (security == null) {
                return null;
            }
            return new HttpServletSecurityImpl(security);
        }
    }

    public static enum Dependencies {
        HTTP_AUTHENTICATION;

    }
}

