/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.container;

import java.io.Serializable;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import net.officefloor.plugin.servlet.container.IteratorEnumeration;
import net.officefloor.plugin.servlet.time.Clock;

public class HttpSessionImpl
implements HttpSession {
    private final net.officefloor.plugin.web.http.session.HttpSession session;
    private final long lastAccessTime;
    private final Clock clock;
    private final ServletContext context;

    public HttpSessionImpl(net.officefloor.plugin.web.http.session.HttpSession session, long lastAccessTime, Clock clock, ServletContext context) {
        this.session = session;
        this.lastAccessTime = lastAccessTime;
        this.clock = clock;
        this.context = context;
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public String getId() {
        return this.session.getSessionId();
    }

    public long getLastAccessedTime() {
        return this.lastAccessTime;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public int getMaxInactiveInterval() {
        long currentTime = this.clock.currentTimeMillis();
        long inactiveInterval = this.session.getExpireTime() - currentTime;
        inactiveInterval = inactiveInterval == 0L ? 0L : inactiveInterval / 1000L;
        return (int)inactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        long expireTime = interval < 0 ? Long.MAX_VALUE : this.clock.currentTimeMillis() + (long)(interval * 1000);
        this.session.setExpireTime(expireTime);
    }

    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return new IteratorEnumeration(this.session.getAttributeNames());
    }

    public void setAttribute(String name, Object value) {
        this.session.setAttribute(name, (Serializable)value);
    }

    public void removeAttribute(String name) {
        this.session.removeAttribute(name);
    }

    public void invalidate() {
        try {
            this.session.getHttpSessionAdministration().invalidate(false);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failure in invalidating session", ex);
        }
    }

    public boolean isNew() {
        return this.session.isNew();
    }

    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException("HttpSession.getSessionContext deprecated as of version 2.1");
    }

    public Object getValue(String name) {
        throw new UnsupportedOperationException("HttpSession.getValue deprecated as of version 2.2");
    }

    public String[] getValueNames() {
        throw new UnsupportedOperationException("HttpSession.getValueNames deprecated as of version 2.2");
    }

    public void putValue(String name, Object value) {
        throw new UnsupportedOperationException("HttpSession.putValue deprecated as of version 2.2");
    }

    public void removeValue(String name) {
        throw new UnsupportedOperationException("HttpSession.removeValue deprecated as of version 2.2");
    }
}

