/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.container;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import net.officefloor.frame.api.execute.TaskContext;
import net.officefloor.frame.api.manage.InvalidParameterTypeException;
import net.officefloor.frame.api.manage.UnknownTaskException;
import net.officefloor.frame.api.manage.UnknownWorkException;
import net.officefloor.plugin.servlet.container.HttpRequestServletInputStream;
import net.officefloor.plugin.servlet.container.IteratorEnumeration;
import net.officefloor.plugin.servlet.container.ServletRequestForwarder;
import net.officefloor.plugin.servlet.security.HttpServletSecurity;
import net.officefloor.plugin.socket.server.http.HttpHeader;
import net.officefloor.plugin.socket.server.http.HttpRequest;
import net.officefloor.plugin.socket.server.http.ServerHttpConnection;
import net.officefloor.plugin.web.http.application.HttpRequestState;
import net.officefloor.plugin.web.http.cookie.HttpCookie;
import net.officefloor.plugin.web.http.cookie.HttpCookieUtil;
import net.officefloor.plugin.web.http.tokenise.HttpRequestTokenHandler;
import net.officefloor.plugin.web.http.tokenise.HttpRequestTokeniseException;
import net.officefloor.plugin.web.http.tokenise.HttpRequestTokeniserImpl;

public class HttpServletRequestImpl
implements HttpServletRequest,
ServletRequestForwarder {
    public static final String RFC1123_HEADER_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String RFC1036_HEADER_DATE_FORMAT = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    private static final String ANSI_C_HEADER_DATE_FORMAT = "EEE MMM d HH:mm:ss yyyy";
    private static final String[] HEADER_DATE_FORMATS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};
    private static TimeZone DATE_HEADER_TIMEZONE = TimeZone.getTimeZone("GMT");
    private static final Date DATE_HEADER_TWO_DIGIT_YEAR_START;
    private static final String HEADER_HOST = "Host";
    private final ServerHttpConnection connection;
    private final HttpRequest request;
    private final HttpServletSecurity security;
    private final String sessionIdIdentifierName;
    private final HttpSession session;
    private final ServletContext servletContext;
    private final Locale defaultLocale;
    private final TaskContext<?, ?, ?> taskContext;
    private final String requestUri;
    private String path = "";
    private final List<HttpParameter> httpParameters = new LinkedList<HttpParameter>();
    private final HttpRequestState attributes;
    private String queryString = "";
    private List<HttpHeader> httpHeaders = null;
    private Map<String, String[]> parameterMap = null;
    private ServletInputStream inputStream = null;
    private BufferedReader reader = null;
    private boolean isSessionIdLoaded = false;
    private boolean isSessionIdFromCookie = false;
    private boolean isSessionIdFromUrl = false;
    private String requestSessionId;

    public HttpServletRequestImpl(ServerHttpConnection connection, HttpRequestState requestAttributes, HttpServletSecurity security, String sessionIdIdentifierName, HttpSession session, ServletContext servletContext, Locale defaultLocale, TaskContext<?, ?, ?> taskContext) throws IOException, HttpRequestTokeniseException {
        this.connection = connection;
        this.request = this.connection.getHttpRequest();
        this.attributes = requestAttributes;
        this.security = security;
        this.sessionIdIdentifierName = sessionIdIdentifierName;
        this.session = session;
        this.servletContext = servletContext;
        this.defaultLocale = defaultLocale;
        this.taskContext = taskContext;
        HttpRequestTokeniserImpl tokeniser = new HttpRequestTokeniserImpl();
        tokeniser.tokeniseHttpRequest(this.request, new HttpRequestTokenHandler(){

            public void handlePath(String path) throws HttpRequestTokeniseException {
                HttpServletRequestImpl.this.path = path;
            }

            public void handleHttpParameter(String name, String value) throws HttpRequestTokeniseException {
                HttpServletRequestImpl.this.httpParameters.add(new HttpParameter(name, value));
            }

            public void handleQueryString(String queryString) throws HttpRequestTokeniseException {
                HttpServletRequestImpl.this.queryString = queryString;
            }

            public void handleFragment(String fragment) throws HttpRequestTokeniseException {
            }
        });
        this.requestUri = this.path;
        String contextPath = this.servletContext.getContextPath();
        if (!"/".equals(contextPath) && this.path.startsWith(contextPath)) {
            this.path = this.path.substring(contextPath.length());
        }
    }

    private List<HttpHeader> getHttpHeaders() {
        if (this.httpHeaders == null) {
            this.httpHeaders = this.request.getHeaders();
        }
        return this.httpHeaders;
    }

    private String getCaseInsensitiveHttpHeader(String name) {
        List<HttpHeader> headers = this.getHttpHeaders();
        for (HttpHeader header : headers) {
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header.getValue();
        }
        return null;
    }

    @Override
    public void forward(String workName, String taskName, Object parameter) throws ServletException {
        try {
            this.taskContext.doFlow(workName, taskName, parameter);
        }
        catch (UnknownWorkException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (UnknownTaskException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (InvalidParameterTypeException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public String getContextPath() {
        return this.servletContext.getContextPath();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getServletPath() {
        return this.path;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestUri;
    }

    public StringBuffer getRequestURL() {
        StringBuffer requestUrl;
        String host = null;
        if (this.requestUri.startsWith("/")) {
            host = this.getCaseInsensitiveHttpHeader(HEADER_HOST);
        }
        if (host == null) {
            requestUrl = new StringBuffer(this.requestUri);
        } else {
            requestUrl = new StringBuffer(host.length() + this.path.length());
            requestUrl.append(host);
            requestUrl.append(this.requestUri);
        }
        return requestUrl;
    }

    public int getContentLength() {
        String contentLength = this.getCaseInsensitiveHttpHeader("Content-Length");
        if (contentLength == null) {
            return -1;
        }
        try {
            return Integer.parseInt(contentLength);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public String getParameter(String name) {
        for (HttpParameter parameter : this.httpParameters) {
            if (!parameter.name.equals(name)) continue;
            return parameter.value;
        }
        return null;
    }

    public Map getParameterMap() {
        if (this.parameterMap == null) {
            this.parameterMap = new HashMap<String, String[]>();
            for (HttpParameter parameter : this.httpParameters) {
                String[] values = this.parameterMap.get(parameter.name);
                if (values == null) {
                    values = new String[]{parameter.value};
                } else {
                    String[] tmp = new String[values.length + 1];
                    System.arraycopy(values, 0, tmp, 0, values.length);
                    tmp[values.length] = parameter.value;
                    values = tmp;
                }
                this.parameterMap.put(parameter.name, values);
            }
            this.parameterMap = Collections.unmodifiableMap(this.parameterMap);
        }
        return this.parameterMap;
    }

    public Enumeration getParameterNames() {
        ArrayList<String> names = new ArrayList<String>(this.httpParameters.size());
        for (HttpParameter parameter : this.httpParameters) {
            String name = parameter.name;
            if (names.contains(name)) continue;
            names.add(name);
        }
        return new IteratorEnumeration(names.iterator());
    }

    public String[] getParameterValues(String name) {
        Map map = this.getParameterMap();
        return (String[])map.get(name);
    }

    public String getProtocol() {
        return this.request.getVersion();
    }

    public BufferedReader getReader() throws IOException {
        if (this.inputStream != null) {
            throw new IllegalStateException("InputStream already provided so can not provide Reader");
        }
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.request.getEntity()));
        }
        return this.reader;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.reader != null) {
            throw new IllegalStateException("Reader already provided so can not provide InputStream");
        }
        if (this.inputStream == null) {
            this.inputStream = new HttpRequestServletInputStream((InputStream)this.request.getEntity());
        }
        return this.inputStream;
    }

    public String getScheme() {
        return this.connection.isSecure() ? "https" : "http";
    }

    public Cookie[] getCookies() {
        List cookies = HttpCookieUtil.extractHttpCookies((HttpRequest)this.request);
        LinkedList<Cookie> list = new LinkedList<Cookie>();
        for (HttpCookie cookie : cookies) {
            list.add(new Cookie(cookie.getName(), cookie.getValue()));
        }
        return list.toArray(new Cookie[0]);
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value != null) {
            SimpleDateFormat dateParser = null;
            for (String dateFormat : HEADER_DATE_FORMATS) {
                if (dateParser == null) {
                    dateParser = new SimpleDateFormat(dateFormat, Locale.US);
                    dateParser.setTimeZone(DATE_HEADER_TIMEZONE);
                    dateParser.set2DigitYearStart(DATE_HEADER_TWO_DIGIT_YEAR_START);
                } else {
                    dateParser.applyPattern(dateFormat);
                }
                try {
                    long date = dateParser.parse(value).getTime();
                    return date;
                }
                catch (Exception ex) {
                }
            }
            throw new IllegalArgumentException("Can not parse header date value '" + value + "'");
        }
        return -1L;
    }

    public String getHeader(String name) {
        List<HttpHeader> headers = this.getHttpHeaders();
        for (HttpHeader header : headers) {
            if (!header.getName().equals(name)) continue;
            return header.getValue();
        }
        return null;
    }

    public Enumeration getHeaderNames() {
        List<HttpHeader> headers = this.getHttpHeaders();
        ArrayList<String> names = new ArrayList<String>(headers.size());
        for (HttpHeader header : headers) {
            String name = header.getName();
            if (names.contains(name)) continue;
            names.add(name);
        }
        return new IteratorEnumeration(names.iterator());
    }

    public Enumeration getHeaders(String name) {
        List<HttpHeader> headers = this.getHttpHeaders();
        ArrayList<String> values = new ArrayList<String>(2);
        for (HttpHeader header : headers) {
            String headerName = header.getName();
            if (!name.equals(headerName)) continue;
            String value = header.getValue();
            values.add(value);
        }
        return new IteratorEnumeration(values.iterator());
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    public String getServerName() {
        String hostHeader = this.getCaseInsensitiveHttpHeader(HEADER_HOST);
        if (hostHeader != null) {
            int separatorIndex = hostHeader.indexOf(58);
            String host = separatorIndex >= 0 ? hostHeader.substring(0, separatorIndex) : hostHeader;
            if ((host = host.trim()).length() > 0) {
                return host;
            }
        }
        return this.getLocalAddr();
    }

    public int getServerPort() {
        int separatorIndex;
        String hostHeader = this.getCaseInsensitiveHttpHeader(HEADER_HOST);
        if (hostHeader != null && (separatorIndex = hostHeader.indexOf(58)) >= 0) {
            String port = hostHeader.substring(separatorIndex + 1);
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return this.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyLoadSessionId() {
        if (this.isSessionIdLoaded) {
            return;
        }
        try {
            Cookie[] cookies;
            for (Cookie cookie : cookies = this.getCookies()) {
                if (!this.sessionIdIdentifierName.equalsIgnoreCase(cookie.getName())) continue;
                this.isSessionIdFromCookie = true;
                this.requestSessionId = cookie.getValue();
                return;
            }
            this.requestSessionId = this.getParameter(this.sessionIdIdentifierName);
            this.isSessionIdFromUrl = this.requestSessionId != null;
        }
        finally {
            this.isSessionIdLoaded = true;
        }
    }

    public String getRequestedSessionId() {
        this.lazyLoadSessionId();
        return this.requestSessionId;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public HttpSession getSession(boolean create) {
        return this.session;
    }

    public boolean isRequestedSessionIdFromCookie() {
        this.lazyLoadSessionId();
        return this.isSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        this.lazyLoadSessionId();
        return this.isSessionIdFromUrl;
    }

    public boolean isRequestedSessionIdValid() {
        this.lazyLoadSessionId();
        if (this.requestSessionId == null) {
            return false;
        }
        String sessionId = this.session.getId();
        return sessionId.equals(this.requestSessionId);
    }

    public Object getAttribute(String name) {
        if ("#net.officefloor.servlet.request.forwarder#".equals(name)) {
            return this;
        }
        return this.attributes.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return new IteratorEnumeration(this.attributes.getAttributeNames());
    }

    public void removeAttribute(String name) {
        this.attributes.removeAttribute(name);
    }

    public void setAttribute(String name, Object object) {
        this.attributes.setAttribute(name, (Serializable)object);
    }

    public String getCharacterEncoding() {
        throw new UnsupportedOperationException("TODO implement ServletRequest.getCharacterEncoding");
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        throw new UnsupportedOperationException("TODO implement ServletRequest.setCharacterEncoding");
    }

    public String getContentType() {
        return this.getCaseInsensitiveHttpHeader("Content-Type");
    }

    public Locale getLocale() {
        return this.defaultLocale;
    }

    public Enumeration getLocales() {
        return new IteratorEnumeration<Locale>(Arrays.asList(this.defaultLocale).iterator());
    }

    public String getLocalAddr() {
        InetSocketAddress localAddress = this.connection.getLocalAddress();
        return localAddress.getAddress().getHostAddress();
    }

    public String getLocalName() {
        InetSocketAddress localAddress = this.connection.getLocalAddress();
        return localAddress.getHostName();
    }

    public int getLocalPort() {
        InetSocketAddress localAddress = this.connection.getLocalAddress();
        return localAddress.getPort();
    }

    public String getRemoteAddr() {
        InetSocketAddress remoteAddress = this.connection.getRemoteAddress();
        return remoteAddress.getAddress().getHostAddress();
    }

    public String getRemoteHost() {
        InetSocketAddress remoteAddress = this.connection.getRemoteAddress();
        return remoteAddress.getHostName();
    }

    public int getRemotePort() {
        InetSocketAddress remoteAddress = this.connection.getRemoteAddress();
        return remoteAddress.getPort();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        String dispatcherPath = path.startsWith("/") ? path : this.path + "/" + path;
        return this.servletContext.getRequestDispatcher(dispatcherPath);
    }

    public boolean isSecure() {
        return this.connection.isSecure();
    }

    public String getAuthType() {
        return this.security == null ? null : this.security.getAuthenticationScheme();
    }

    public Principal getUserPrincipal() {
        return this.security == null ? null : this.security.getUserPrincipal();
    }

    public String getRemoteUser() {
        return this.security == null ? null : this.security.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.security == null ? false : this.security.isUserInRole(role);
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException("ServletRequest.getRealPath(path) deprecated as of version 2.1");
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException("HttpServletRequest.isRequestedSessionIdFromUrl deprecated as of version 2.1");
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException("TODO WoOF to support Servlet 3.0 specification");
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException("TODO WoOF to support Servlet 3.0 specification");
    }

    public ServletContext getServletContext() {
        throw new UnsupportedOperationException("TODO WoOF to support Servlet 3.0 specification");
    }

    public boolean isAsyncStarted() {
        throw new UnsupportedOperationException("TODO WoOF to support Servlet 3.0 specification");
    }

    public boolean isAsyncSupported() {
        throw new UnsupportedOperationException("TODO WoOF to support Servlet 3.0 specification");
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new UnsupportedOperationException("TODO WoOF to support Servlet 3.0 specification");
    }

    public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) throws IllegalStateException {
        throw new UnsupportedOperationException("TODO WoOF to support Servlet 3.0 specification");
    }

    public boolean authenticate(HttpServletResponse arg0) throws IOException, ServletException {
        throw new UnsupportedOperationException("TODO WoOF to support Servlet 3.0 specification");
    }

    public Part getPart(String arg0) throws IOException, ServletException {
        throw new UnsupportedOperationException("TODO WoOF to support Servlet 3.0 specification");
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        throw new UnsupportedOperationException("TODO WoOF to support Servlet 3.0 specification");
    }

    public void login(String arg0, String arg1) throws ServletException {
        throw new UnsupportedOperationException("TODO WoOF to support Servlet 3.0 specification");
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException("TODO WoOF to support Servlet 3.0 specification");
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2000, 0, 1, 0, 0);
        DATE_HEADER_TWO_DIGIT_YEAR_START = calendar.getTime();
    }

    private static class HttpParameter {
        public final String name;
        public final String value;

        public HttpParameter(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

