/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.container;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.officefloor.frame.api.execute.TaskContext;
import net.officefloor.frame.api.manage.Office;
import net.officefloor.plugin.servlet.container.HttpServletContainer;
import net.officefloor.plugin.servlet.container.HttpServletRequestImpl;
import net.officefloor.plugin.servlet.container.HttpServletResponseImpl;
import net.officefloor.plugin.servlet.container.HttpServletServicer;
import net.officefloor.plugin.servlet.container.HttpSessionImpl;
import net.officefloor.plugin.servlet.container.ServletConfigImpl;
import net.officefloor.plugin.servlet.container.ServletContextImpl;
import net.officefloor.plugin.servlet.context.MappedHttpServletRequest;
import net.officefloor.plugin.servlet.context.OfficeServletContext;
import net.officefloor.plugin.servlet.filter.FilterChainFactory;
import net.officefloor.plugin.servlet.mapping.MappingType;
import net.officefloor.plugin.servlet.mapping.ServicerMapping;
import net.officefloor.plugin.servlet.security.HttpServletSecurity;
import net.officefloor.plugin.servlet.time.Clock;
import net.officefloor.plugin.socket.server.http.ServerHttpConnection;
import net.officefloor.plugin.web.http.application.HttpRequestState;
import net.officefloor.plugin.web.http.session.HttpSession;
import net.officefloor.plugin.web.http.tokenise.HttpRequestTokeniseException;

public class HttpServletContainerImpl
implements HttpServletContainer,
HttpServletServicer,
FilterChain {
    private static final String ATTRIBUTE_LAST_ACCESS_TIME = "#HttpServlet.LastAccessTime#";
    private final String servletName;
    private final HttpServlet servlet;
    private final FilterChainFactory filterChainFactory;
    private final ServletContext servletContext;
    private final Clock clock;
    private final Locale defaultLocale;

    public HttpServletContainerImpl(String servletName, HttpServlet servlet, Map<String, String> initParameters, OfficeServletContext officeServletContext, Office office, Clock clock, Locale defaultLocale) throws ServletException {
        this.servletName = servletName;
        this.servlet = servlet;
        this.clock = clock;
        this.defaultLocale = defaultLocale;
        this.servletContext = new ServletContextImpl(officeServletContext, office);
        this.filterChainFactory = officeServletContext.getFilterChainFactory(office);
        this.servlet.init((ServletConfig)new ServletConfigImpl(servletName, this.servletContext, initParameters));
    }

    private void service(ServicerMapping mapping, MappingType mappingType, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServletContainerImpl target = this;
        FilterChain filterChain = this.filterChainFactory.createFilterChain(mapping, mappingType, target);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Override
    public void service(ServerHttpConnection connection, HttpRequestState attributes, HttpSession session, HttpServletSecurity security, TaskContext<?, ?, ?> taskContext, ServicerMapping mapping) throws ServletException, IOException {
        HttpServletResponseImpl response;
        MappingType mappingType;
        Object request;
        Long lastAccessTime = (Long)attributes.getAttribute(ATTRIBUTE_LAST_ACCESS_TIME);
        if (lastAccessTime == null) {
            lastAccessTime = (Long)session.getAttribute(ATTRIBUTE_LAST_ACCESS_TIME);
            long currentTime = this.clock.currentTimeMillis();
            if (lastAccessTime == null) {
                lastAccessTime = new Long(currentTime);
            }
            attributes.setAttribute(ATTRIBUTE_LAST_ACCESS_TIME, (Serializable)lastAccessTime);
            session.setAttribute(ATTRIBUTE_LAST_ACCESS_TIME, (Serializable)new Long(currentTime));
        }
        try {
            HttpSessionImpl httpSession = new HttpSessionImpl(session, lastAccessTime, this.clock, this.servletContext);
            String sessionIdTokenName = session.getTokenName();
            request = new HttpServletRequestImpl(connection, attributes, security, sessionIdTokenName, httpSession, this.servletContext, this.defaultLocale, taskContext);
            if (mapping != null) {
                request = new MappedHttpServletRequest(mapping, (HttpServletRequest)request);
                mappingType = MappingType.FORWARD;
            } else {
                mapping = new RequestServicerMapping((HttpServletRequest)request);
                mappingType = MappingType.REQUEST;
            }
            response = new HttpServletResponseImpl(connection.getHttpResponse(), this.clock, (HttpServletRequest)request, this.defaultLocale);
        }
        catch (HttpRequestTokeniseException ex) {
            throw new IOException(ex);
        }
        this.service(mapping, mappingType, (HttpServletRequest)request, response);
        response.flushBuffers();
    }

    @Override
    public void include(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestServicerMapping mapping = new RequestServicerMapping(request);
        MappingType mappingType = MappingType.INCLUDE;
        this.service(mapping, mappingType, request, response);
    }

    @Override
    public String getServletName() {
        return this.servletName;
    }

    @Override
    public String[] getServletMappings() {
        return new String[0];
    }

    @Override
    public void include(OfficeServletContext context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.include(request, response);
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        this.servlet.service(request, response);
    }

    private class RequestServicerMapping
    implements ServicerMapping {
        private final HttpServletRequest request;

        public RequestServicerMapping(HttpServletRequest request) {
            this.request = request;
        }

        @Override
        public HttpServletServicer getServicer() {
            return HttpServletContainerImpl.this;
        }

        @Override
        public String getServletPath() {
            return this.request.getServletPath();
        }

        @Override
        public String getPathInfo() {
            return this.request.getPathInfo();
        }

        @Override
        public String getQueryString() {
            return this.request.getQueryString();
        }

        @Override
        public String getParameter(String name) {
            return this.request.getParameter(name);
        }

        @Override
        public Map<String, String[]> getParameterMap() {
            return this.request.getParameterMap();
        }

        @Override
        public Enumeration<String> getParameterNames() {
            return this.request.getParameterNames();
        }

        @Override
        public String[] getParameterValues(String name) {
            return this.getParameterValues(name);
        }
    }
}

