/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.stream.outputstream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.officefloor.plugin.stream.BufferPopulator;
import net.officefloor.plugin.stream.BufferSquirt;
import net.officefloor.plugin.stream.OutputBufferStream;
import net.officefloor.plugin.stream.synchronise.SynchronizedOutputStream;

public class OutputStreamOutputBufferStream
implements OutputBufferStream {
    private final OutputStream output;

    public OutputStreamOutputBufferStream(OutputStream output) {
        this.output = new SynchronizedOutputStream(output, (Object)this);
    }

    public synchronized OutputStream getOutputStream() {
        return this.output;
    }

    public void write(byte[] bytes) throws IOException {
        this.output.write(bytes);
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        this.output.write(data, offset, length);
    }

    public void write(BufferPopulator populator) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        populator.populate(buffer);
        buffer.flip();
        this.append(buffer);
    }

    public synchronized void append(ByteBuffer buffer) throws IOException {
        while (buffer.remaining() > 0) {
            this.output.write(buffer.get());
        }
    }

    public void append(BufferSquirt squirt) throws IOException {
        this.append(squirt.getBuffer());
    }

    public void close() throws IOException {
        this.output.close();
    }
}

