/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.officefloor.autowire.AutoWire;
import net.officefloor.autowire.AutoWireObject;
import net.officefloor.autowire.AutoWireOfficeFloor;
import net.officefloor.autowire.AutoWireSection;
import net.officefloor.autowire.impl.AutoWireOfficeFloorSource;
import net.officefloor.frame.impl.spi.team.ProcessContextTeamSource;
import net.officefloor.frame.spi.source.ResourceSource;
import net.officefloor.plugin.servlet.ServletContainerResourceSectionSource;
import net.officefloor.plugin.servlet.ServletDependencyManagedObjectSource;
import net.officefloor.plugin.servlet.bridge.ServletBridgeManagedObjectSource;
import net.officefloor.plugin.servlet.bridge.spi.ServletServiceBridger;
import net.officefloor.plugin.servlet.socket.server.http.ServletServerHttpConnection;
import net.officefloor.plugin.servlet.socket.server.http.source.ServletServerHttpConnectionManagedObjectSource;
import net.officefloor.plugin.servlet.web.http.application.ServletHttpApplicationStateManagedObjectSource;
import net.officefloor.plugin.servlet.web.http.application.ServletHttpRequestStateManagedObjectSource;
import net.officefloor.plugin.servlet.web.http.session.ServletHttpSessionManagedObjectSource;
import net.officefloor.plugin.socket.server.http.ServerHttpConnection;
import net.officefloor.plugin.web.http.application.HttpApplicationState;
import net.officefloor.plugin.web.http.application.HttpRequestState;
import net.officefloor.plugin.web.http.application.WebApplicationAutoWireOfficeFloorSource;
import net.officefloor.plugin.web.http.application.WebAutoWireApplication;
import net.officefloor.plugin.web.http.session.HttpSession;

public abstract class OfficeFloorServletFilter
extends WebApplicationAutoWireOfficeFloorSource
implements Filter,
WebAutoWireApplication {
    private FilterConfig filterConfig;
    private ServletServiceBridger bridger;
    private AutoWireOfficeFloor officeFloor;
    private final List<ServletResourceLink> servletResourceLinks = new LinkedList<ServletResourceLink>();
    private final List<ServletResourceEscalation> servletResourceEscalations = new LinkedList<ServletResourceEscalation>();
    private final Set<String> handledURIs = new HashSet<String>();

    protected FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected abstract void configure() throws Exception;

    public void linkToResource(AutoWireSection section, String outputName, String requestDispatcherPath) {
        this.servletResourceLinks.add(new ServletResourceLink(section, outputName, requestDispatcherPath));
    }

    public void linkEscalation(Class<? extends Throwable> escalation, String resourcePath) {
        this.servletResourceEscalations.add(new ServletResourceEscalation(escalation, resourcePath));
    }

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        this.bridger = ServletBridgeManagedObjectSource.createServletServiceBridger(((Object)((Object)this)).getClass(), (AutoWireOfficeFloorSource)this, "HANDLE_HTTP_SECTION", "HANDLE_HTTP_INPUT");
        this.getOfficeFloorCompiler().addResources(new ResourceSource(){

            public InputStream sourceResource(String location) {
                location = location.startsWith("/") ? location : "/" + location;
                InputStream resource = OfficeFloorServletFilter.this.getFilterConfig().getServletContext().getResourceAsStream(location);
                return resource;
            }
        });
        this.addManagedObject(ServletServerHttpConnectionManagedObjectSource.class.getName(), null, new AutoWire[]{new AutoWire(ServerHttpConnection.class)});
        this.addManagedObject(ServletHttpSessionManagedObjectSource.class.getName(), null, new AutoWire[]{new AutoWire(HttpSession.class)});
        this.addManagedObject(ServletHttpApplicationStateManagedObjectSource.class.getName(), null, new AutoWire[]{new AutoWire(HttpApplicationState.class)});
        this.addManagedObject(ServletHttpRequestStateManagedObjectSource.class.getName(), null, new AutoWire[]{new AutoWire(HttpRequestState.class)});
        AutoWireSection servletContainerResource = this.addSection("SERVLET_CONTAINER_RESOURCE", ServletContainerResourceSectionSource.class.getName(), "NOT_HANDLED");
        this.setNonHandledServicer(servletContainerResource, "NOT_HANDLED");
        Class<?>[] dependencyTypes = this.bridger.getObjectTypes();
        for (Class<?> clazz : dependencyTypes) {
            AutoWireObject dependency = this.addManagedObject(ServletDependencyManagedObjectSource.class.getName(), null, new AutoWire[]{new AutoWire(clazz)});
            dependency.addProperty("type.name", clazz.getName());
        }
        if (dependencyTypes.length > 0) {
            AutoWire[] autoWiring = new AutoWire[dependencyTypes.length];
            for (int i = 0; i < autoWiring.length; ++i) {
                autoWiring[i] = new AutoWire(dependencyTypes[i]);
            }
            this.assignTeam(ProcessContextTeamSource.class.getName(), autoWiring);
        }
        try {
            this.configure();
        }
        catch (Exception ex) {
            if (ex instanceof ServletException) {
                throw (ServletException)ex;
            }
            throw new ServletException((Throwable)ex);
        }
        for (String string : this.getURIs()) {
            String string2 = string.startsWith("/") ? string : "/" + (String)string;
            this.handledURIs.add(string2);
        }
        for (ServletResourceLink link : this.servletResourceLinks) {
            servletContainerResource.addProperty(link.requestDispatcherPath, link.requestDispatcherPath);
            this.link(link.section, link.outputName, servletContainerResource, link.requestDispatcherPath);
        }
        for (ServletResourceEscalation handling : this.servletResourceEscalations) {
            servletContainerResource.addProperty(handling.requestDispatcherPath, handling.requestDispatcherPath);
            this.linkEscalation(handling.escalationType, servletContainerResource, handling.requestDispatcherPath);
        }
        try {
            this.officeFloor = this.openOfficeFloor();
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uri = ServletServerHttpConnection.getRequestUri(httpRequest);
        if (this.handledURIs.contains(uri) || uri.endsWith(".task")) {
            this.bridger.service(this, httpRequest, httpResponse, this.getFilterConfig().getServletContext());
            if (ServletContainerResourceSectionSource.completeServletService(httpRequest, httpResponse)) {
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        if (this.officeFloor != null) {
            this.officeFloor.closeOfficeFloor();
        }
    }

    private static class ServletResourceEscalation {
        public final Class<? extends Throwable> escalationType;
        public final String requestDispatcherPath;

        public ServletResourceEscalation(Class<? extends Throwable> escalationType, String requestDispatcherPath) {
            this.escalationType = escalationType;
            this.requestDispatcherPath = requestDispatcherPath;
        }
    }

    private static class ServletResourceLink {
        public final AutoWireSection section;
        public final String outputName;
        public final String requestDispatcherPath;

        public ServletResourceLink(AutoWireSection section, String outputName, String requestDispatcherPath) {
            this.section = section;
            this.outputName = outputName;
            this.requestDispatcherPath = requestDispatcherPath;
        }
    }
}

