/*
 * 
 */
package net.officefloor.plugin.servlet.webxml.model;

import java.util.List;
import java.util.LinkedList;

import javax.annotation.Generated;

import net.officefloor.model.AbstractModel;
import net.officefloor.model.ItemModel;
import net.officefloor.model.RemoveConnectionsAction;

@Generated("net.officefloor.model.generate.ModelGenerator")
public class WebAppModel extends AbstractModel implements ItemModel<WebAppModel> {

    public static enum WebAppEvent {
     CHANGE_VERSION, CHANGE_DISPLAY_NAME, ADD_CONTEXT_PARAM, REMOVE_CONTEXT_PARAM, ADD_MIME_MAPPING, REMOVE_MIME_MAPPING, ADD_SERVLET, REMOVE_SERVLET, ADD_SERVLET_MAPPING, REMOVE_SERVLET_MAPPING, ADD_FILTER, REMOVE_FILTER, ADD_FILTER_MAPPING, REMOVE_FILTER_MAPPING
    }

    /**
     * Default constructor.
     */
    public WebAppModel() {
    }

    /**
     * Convenience constructor for new non-linked instance.
     */
    public WebAppModel(
      String version
    , String displayName
    ) {
        this.version = version;
        this.displayName = displayName;
    }

    /**
     * Convenience constructor.
     */
    public WebAppModel(
      String version
    , String displayName
    , ContextParamModel[] contextParam
    , MimeMappingModel[] mimeMapping
    , ServletModel[] servlet
    , ServletMappingModel[] servletMapping
    , FilterModel[] filter
    , FilterMappingModel[] filterMapping
    ) {
        this.version = version;
        this.displayName = displayName;
        if (contextParam != null) {
            for (ContextParamModel model : contextParam) {
                this.contextParam.add(model);
            }
        }
        if (mimeMapping != null) {
            for (MimeMappingModel model : mimeMapping) {
                this.mimeMapping.add(model);
            }
        }
        if (servlet != null) {
            for (ServletModel model : servlet) {
                this.servlet.add(model);
            }
        }
        if (servletMapping != null) {
            for (ServletMappingModel model : servletMapping) {
                this.servletMapping.add(model);
            }
        }
        if (filter != null) {
            for (FilterModel model : filter) {
                this.filter.add(model);
            }
        }
        if (filterMapping != null) {
            for (FilterMappingModel model : filterMapping) {
                this.filterMapping.add(model);
            }
        }
    }

    /**
     * Convenience constructor allowing XY initialising.
     */
    public WebAppModel(
      String version
    , String displayName
    , ContextParamModel[] contextParam
    , MimeMappingModel[] mimeMapping
    , ServletModel[] servlet
    , ServletMappingModel[] servletMapping
    , FilterModel[] filter
    , FilterMappingModel[] filterMapping
    , int x
    , int y
    ) {
        this.version = version;
        this.displayName = displayName;
        if (contextParam != null) {
            for (ContextParamModel model : contextParam) {
                this.contextParam.add(model);
            }
        }
        if (mimeMapping != null) {
            for (MimeMappingModel model : mimeMapping) {
                this.mimeMapping.add(model);
            }
        }
        if (servlet != null) {
            for (ServletModel model : servlet) {
                this.servlet.add(model);
            }
        }
        if (servletMapping != null) {
            for (ServletMappingModel model : servletMapping) {
                this.servletMapping.add(model);
            }
        }
        if (filter != null) {
            for (FilterModel model : filter) {
                this.filter.add(model);
            }
        }
        if (filterMapping != null) {
            for (FilterMappingModel model : filterMapping) {
                this.filterMapping.add(model);
            }
        }
        this.setX(x);
        this.setY(y);
    }

    /**
     * Version.
     */
    private String version;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        String oldValue = this.version;
        this.version = version;
        this.changeField(oldValue, this.version, WebAppEvent.CHANGE_VERSION);
    }

    /**
     * Display name.
     */
    private String displayName;

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        String oldValue = this.displayName;
        this.displayName = displayName;
        this.changeField(oldValue, this.displayName, WebAppEvent.CHANGE_DISPLAY_NAME);
    }


    /**
     * Context param.
     */
    private List<ContextParamModel> contextParam = new LinkedList<ContextParamModel>();

    public List<ContextParamModel> getContextParams() {
        return this.contextParam;
    }

    public void addContextParam(ContextParamModel contextParam) {
        this.addItemToList(contextParam, this.contextParam, WebAppEvent.ADD_CONTEXT_PARAM);
    }

    public void removeContextParam(ContextParamModel contextParam) {
        this.removeItemFromList(contextParam, this.contextParam, WebAppEvent.REMOVE_CONTEXT_PARAM);
    }

    /**
     * Mime mapping.
     */
    private List<MimeMappingModel> mimeMapping = new LinkedList<MimeMappingModel>();

    public List<MimeMappingModel> getMimeMappings() {
        return this.mimeMapping;
    }

    public void addMimeMapping(MimeMappingModel mimeMapping) {
        this.addItemToList(mimeMapping, this.mimeMapping, WebAppEvent.ADD_MIME_MAPPING);
    }

    public void removeMimeMapping(MimeMappingModel mimeMapping) {
        this.removeItemFromList(mimeMapping, this.mimeMapping, WebAppEvent.REMOVE_MIME_MAPPING);
    }

    /**
     * Servlet.
     */
    private List<ServletModel> servlet = new LinkedList<ServletModel>();

    public List<ServletModel> getServlets() {
        return this.servlet;
    }

    public void addServlet(ServletModel servlet) {
        this.addItemToList(servlet, this.servlet, WebAppEvent.ADD_SERVLET);
    }

    public void removeServlet(ServletModel servlet) {
        this.removeItemFromList(servlet, this.servlet, WebAppEvent.REMOVE_SERVLET);
    }

    /**
     * Servlet mapping.
     */
    private List<ServletMappingModel> servletMapping = new LinkedList<ServletMappingModel>();

    public List<ServletMappingModel> getServletMappings() {
        return this.servletMapping;
    }

    public void addServletMapping(ServletMappingModel servletMapping) {
        this.addItemToList(servletMapping, this.servletMapping, WebAppEvent.ADD_SERVLET_MAPPING);
    }

    public void removeServletMapping(ServletMappingModel servletMapping) {
        this.removeItemFromList(servletMapping, this.servletMapping, WebAppEvent.REMOVE_SERVLET_MAPPING);
    }

    /**
     * Filter.
     */
    private List<FilterModel> filter = new LinkedList<FilterModel>();

    public List<FilterModel> getFilters() {
        return this.filter;
    }

    public void addFilter(FilterModel filter) {
        this.addItemToList(filter, this.filter, WebAppEvent.ADD_FILTER);
    }

    public void removeFilter(FilterModel filter) {
        this.removeItemFromList(filter, this.filter, WebAppEvent.REMOVE_FILTER);
    }

    /**
     * Filter mapping.
     */
    private List<FilterMappingModel> filterMapping = new LinkedList<FilterMappingModel>();

    public List<FilterMappingModel> getFilterMappings() {
        return this.filterMapping;
    }

    public void addFilterMapping(FilterMappingModel filterMapping) {
        this.addItemToList(filterMapping, this.filterMapping, WebAppEvent.ADD_FILTER_MAPPING);
    }

    public void removeFilterMapping(FilterMappingModel filterMapping) {
        this.removeItemFromList(filterMapping, this.filterMapping, WebAppEvent.REMOVE_FILTER_MAPPING);
    }


    /**
     * Remove Connections.
     */
    public RemoveConnectionsAction<WebAppModel> removeConnections() {
        RemoveConnectionsAction<WebAppModel> _action = new RemoveConnectionsAction<WebAppModel>(this);
        return _action;
    }
}
