/*
 * 
 */
package net.officefloor.plugin.servlet.webxml.model;

import java.util.List;
import java.util.LinkedList;

import javax.annotation.Generated;

import net.officefloor.model.AbstractModel;
import net.officefloor.model.ItemModel;
import net.officefloor.model.RemoveConnectionsAction;

@Generated("net.officefloor.model.generate.ModelGenerator")
public class FilterModel extends AbstractModel implements ItemModel<FilterModel> {

    public static enum FilterEvent {
     CHANGE_FILTER_NAME, CHANGE_FILTER_CLASS, ADD_INIT_PARAM, REMOVE_INIT_PARAM
    }

    /**
     * Default constructor.
     */
    public FilterModel() {
    }

    /**
     * Convenience constructor for new non-linked instance.
     */
    public FilterModel(
      String filterName
    , String filterClass
    ) {
        this.filterName = filterName;
        this.filterClass = filterClass;
    }

    /**
     * Convenience constructor.
     */
    public FilterModel(
      String filterName
    , String filterClass
    , InitParamModel[] initParam
    ) {
        this.filterName = filterName;
        this.filterClass = filterClass;
        if (initParam != null) {
            for (InitParamModel model : initParam) {
                this.initParam.add(model);
            }
        }
    }

    /**
     * Convenience constructor allowing XY initialising.
     */
    public FilterModel(
      String filterName
    , String filterClass
    , InitParamModel[] initParam
    , int x
    , int y
    ) {
        this.filterName = filterName;
        this.filterClass = filterClass;
        if (initParam != null) {
            for (InitParamModel model : initParam) {
                this.initParam.add(model);
            }
        }
        this.setX(x);
        this.setY(y);
    }

    /**
     * Filter name.
     */
    private String filterName;

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        String oldValue = this.filterName;
        this.filterName = filterName;
        this.changeField(oldValue, this.filterName, FilterEvent.CHANGE_FILTER_NAME);
    }

    /**
     * Filter class.
     */
    private String filterClass;

    public String getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(String filterClass) {
        String oldValue = this.filterClass;
        this.filterClass = filterClass;
        this.changeField(oldValue, this.filterClass, FilterEvent.CHANGE_FILTER_CLASS);
    }


    /**
     * Init param.
     */
    private List<InitParamModel> initParam = new LinkedList<InitParamModel>();

    public List<InitParamModel> getInitParams() {
        return this.initParam;
    }

    public void addInitParam(InitParamModel initParam) {
        this.addItemToList(initParam, this.initParam, FilterEvent.ADD_INIT_PARAM);
    }

    public void removeInitParam(InitParamModel initParam) {
        this.removeItemFromList(initParam, this.initParam, FilterEvent.REMOVE_INIT_PARAM);
    }


    /**
     * Remove Connections.
     */
    public RemoveConnectionsAction<FilterModel> removeConnections() {
        RemoveConnectionsAction<FilterModel> _action = new RemoveConnectionsAction<FilterModel>(this);
        return _action;
    }
}
