/*
 * OfficeFloor - http://www.officefloor.net
 * Copyright (C) 2005-2012 Daniel Sagenschneider
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.officefloor.plugin.servlet.web.http.session;

import java.util.Enumeration;
import java.util.Iterator;

/**
 * {@link Iterator} backed by an {@link Enumeration}.
 * 
 * @author Daniel Sagenschneider
 */
public class EnumerationIterator<E> implements Iterator<E> {

	/**
	 * {@link Enumeration}.
	 */
	private final Enumeration<E> enumeration;

	/**
	 * Initiate.
	 * 
	 * @param enumeration
	 *            {@link Enumeration}.
	 */
	public EnumerationIterator(Enumeration<E> enumeration) {
		this.enumeration = enumeration;
	}

	/*
	 * ===================== Iterator ===================
	 */

	@Override
	public boolean hasNext() {
		return this.enumeration.hasMoreElements();
	}

	@Override
	public E next() {
		return this.enumeration.nextElement();
	}

	@Override
	public void remove() {
		throw new UnsupportedOperationException(
				"Can not remove from Enumeration");
	}

}