/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.web.http.session;

import java.io.Serializable;
import java.util.Iterator;
import javax.servlet.http.HttpSession;
import net.officefloor.plugin.servlet.time.Clock;
import net.officefloor.plugin.servlet.web.http.session.EnumerationIterator;
import net.officefloor.plugin.web.http.session.HttpSessionAdministration;
import net.officefloor.plugin.web.http.session.InvalidatedHttpSessionException;
import net.officefloor.plugin.web.http.session.StoringHttpSessionException;

public class ServletHttpSession
implements net.officefloor.plugin.web.http.session.HttpSession,
HttpSessionAdministration {
    private final HttpSession session;
    private final Clock clock;
    private final String tokenName;

    public ServletHttpSession(HttpSession session, Clock clock, String tokenName) {
        this.session = session;
        this.clock = clock;
        this.tokenName = tokenName;
    }

    public String getSessionId() throws InvalidatedHttpSessionException {
        return this.session.getId();
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public boolean isNew() throws InvalidatedHttpSessionException {
        return this.session.isNew();
    }

    public long getCreationTime() throws InvalidatedHttpSessionException {
        return this.session.getCreationTime();
    }

    public long getExpireTime() throws InvalidatedHttpSessionException {
        long expireTime = this.clock.currentTimeMillis() + (long)(this.session.getMaxInactiveInterval() * 1000);
        return expireTime;
    }

    public void setExpireTime(long expireTime) throws StoringHttpSessionException, InvalidatedHttpSessionException {
        long maxIntervalTimeMilli = expireTime - this.clock.currentTimeMillis();
        int maxIntervalTime = (int)(maxIntervalTimeMilli / 1000L);
        this.session.setMaxInactiveInterval(maxIntervalTime);
    }

    public Serializable getAttribute(String name) throws InvalidatedHttpSessionException {
        return (Serializable)this.session.getAttribute(name);
    }

    public Iterator<String> getAttributeNames() throws InvalidatedHttpSessionException {
        return new EnumerationIterator<String>(this.session.getAttributeNames());
    }

    public void setAttribute(String name, Serializable object) throws StoringHttpSessionException, InvalidatedHttpSessionException {
        this.session.setAttribute(name, (Object)object);
    }

    public void removeAttribute(String name) throws StoringHttpSessionException, InvalidatedHttpSessionException {
        this.session.removeAttribute(name);
    }

    public HttpSessionAdministration getHttpSessionAdministration() {
        return this;
    }

    public void invalidate(boolean isRequireNewSession) throws Throwable {
        this.session.invalidate();
    }

    public boolean isOperationComplete() throws Throwable {
        return true;
    }

    public void store() throws Throwable {
    }
}

