/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.socket.server.http;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.officefloor.plugin.socket.server.http.HttpHeader;
import net.officefloor.plugin.socket.server.http.HttpRequest;
import net.officefloor.plugin.socket.server.http.parse.impl.HttpHeaderImpl;
import net.officefloor.plugin.stream.impl.ServerInputStreamImpl;

public class ServletHttpRequest
implements HttpRequest {
    private final HttpServletRequest servletRequest;
    private final String method;
    private final String requestUri;
    private List<HttpHeader> headers = null;
    private ServerInputStreamImpl entity = null;

    public ServletHttpRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
        this.method = null;
        this.requestUri = null;
    }

    ServletHttpRequest(HttpServletRequest servletRequest, Serializable momento) {
        this.servletRequest = servletRequest;
        StateMomento state = (StateMomento)momento;
        this.method = state.method;
        this.requestUri = state.requestUri;
        this.headers = new ArrayList<HttpHeader>(state.headers);
        this.entity = new ServerInputStreamImpl((Object)this.servletRequest, state.entityState);
    }

    Serializable exportState() throws IOException {
        String method = this.getMethod();
        String requestUri = this.getRequestURI();
        ArrayList<HttpHeader> headers = new ArrayList<HttpHeader>(this.getHeaders());
        Serializable entityState = this.getEntity().exportState();
        return new StateMomento(method, requestUri, headers, entityState);
    }

    public String getMethod() {
        return this.method != null ? this.method : this.servletRequest.getMethod();
    }

    public String getRequestURI() {
        if (this.requestUri != null) {
            return this.requestUri;
        }
        String requestUri = this.servletRequest.getRequestURI();
        String queryString = this.servletRequest.getQueryString();
        if (queryString == null || queryString.length() == 0) {
            return requestUri;
        }
        return requestUri + "?" + queryString;
    }

    public String getVersion() {
        return this.servletRequest.getProtocol();
    }

    public synchronized List<HttpHeader> getHeaders() {
        if (this.headers == null) {
            this.headers = new ArrayList<HttpHeader>();
            Enumeration headerNames = this.servletRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration values = this.servletRequest.getHeaders(headerName);
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    this.headers.add((HttpHeader)new HttpHeaderImpl(headerName, value));
                }
            }
        }
        return this.headers;
    }

    public synchronized ServerInputStreamImpl getEntity() throws IOException {
        if (this.entity == null) {
            int contentLength = this.servletRequest.getContentLength();
            byte[] data = new byte[contentLength];
            ServletInputStream inputStream = this.servletRequest.getInputStream();
            int bytesRead = inputStream.read(data);
            if (bytesRead < 0) {
                bytesRead = 0;
            }
            ServerInputStreamImpl requestEntity = new ServerInputStreamImpl((Object)this.servletRequest);
            requestEntity.inputData(data, 0, bytesRead - 1, false);
            this.entity = requestEntity;
        }
        return this.entity;
    }

    private static class StateMomento
    implements Serializable {
        private final String method;
        private final String requestUri;
        private final List<HttpHeader> headers;
        private final Serializable entityState;

        public StateMomento(String method, String requestUri, List<HttpHeader> headers, Serializable entityState) {
            this.method = method;
            this.requestUri = requestUri;
            this.headers = headers;
            this.entityState = entityState;
        }
    }
}

