/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.host;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.spi.managedobject.CoordinatingManagedObject;
import net.officefloor.frame.spi.managedobject.ManagedObject;
import net.officefloor.frame.spi.managedobject.ObjectRegistry;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectSourceContext;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractAsyncManagedObjectSource;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractManagedObjectSource;
import net.officefloor.plugin.servlet.host.ServletServer;
import net.officefloor.plugin.servlet.resource.ClassPathResourceLocator;
import net.officefloor.plugin.servlet.resource.ResourceLocator;
import net.officefloor.plugin.web.http.location.HttpApplicationLocation;

public class ServletServerManagedObjectSource
extends AbstractManagedObjectSource<Dependencies, None>
implements net.officefloor.plugin.servlet.log.Logger {
    private static final Logger LOGGER = Logger.getLogger(ServletServer.class.getName());
    public static final String PROPERTY_CLASS_PATH_PREFIX = "class.path.prefix";
    private ResourceLocator resourceLocator;

    @Override
    public void log(String message) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, message);
        }
    }

    @Override
    public void log(String message, Throwable failure) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, message, failure);
        }
    }

    protected void loadSpecification(AbstractAsyncManagedObjectSource.SpecificationContext context) {
    }

    protected void loadMetaData(AbstractAsyncManagedObjectSource.MetaDataContext<Dependencies, None> context) throws Exception {
        ManagedObjectSourceContext mosContext = context.getManagedObjectSourceContext();
        String classPathPrefix = mosContext.getProperty(PROPERTY_CLASS_PATH_PREFIX, "PUBLIC");
        ClassLoader classLoader = mosContext.getClassLoader();
        this.resourceLocator = new ClassPathResourceLocator(classPathPrefix, classLoader, new String[0]);
        context.setObjectClass(ServletServer.class);
        context.setManagedObjectClass(ServletServerManagedObject.class);
        context.addDependency((Enum)Dependencies.HTTP_APPLICATION_LOCATION, HttpApplicationLocation.class);
    }

    protected ManagedObject getManagedObject() throws Throwable {
        return new ServletServerManagedObject(this.resourceLocator, this);
    }

    private static class ServletServerManagedObject
    implements CoordinatingManagedObject<Dependencies>,
    ServletServer {
        private final ResourceLocator resourceLocator;
        private final net.officefloor.plugin.servlet.log.Logger logger;
        private HttpApplicationLocation location;

        public ServletServerManagedObject(ResourceLocator resourceLocator, net.officefloor.plugin.servlet.log.Logger logger) {
            this.resourceLocator = resourceLocator;
            this.logger = logger;
        }

        public void loadObjects(ObjectRegistry<Dependencies> registry) throws Throwable {
            this.location = (HttpApplicationLocation)registry.getObject((Enum)Dependencies.HTTP_APPLICATION_LOCATION);
        }

        public Object getObject() throws Throwable {
            return this;
        }

        @Override
        public String getServerName() {
            return this.location.getDomain();
        }

        @Override
        public int getServerPort() {
            return this.location.getHttpPort();
        }

        @Override
        public String getContextPath() {
            String contextPath = this.location.getContextPath();
            if (contextPath == null) {
                contextPath = "/";
            }
            return contextPath;
        }

        @Override
        public ResourceLocator getResourceLocator() {
            return this.resourceLocator;
        }

        @Override
        public net.officefloor.plugin.servlet.log.Logger getLogger() {
            return this.logger;
        }
    }

    public static enum Dependencies {
        HTTP_APPLICATION_LOCATION;

    }
}

