/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.container.source;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.officefloor.compile.spi.work.source.TaskTypeBuilder;
import net.officefloor.compile.spi.work.source.WorkSourceContext;
import net.officefloor.compile.spi.work.source.WorkTypeBuilder;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.api.build.OfficeAwareWorkFactory;
import net.officefloor.frame.api.build.TaskFactory;
import net.officefloor.frame.api.build.WorkFactory;
import net.officefloor.frame.api.execute.TaskContext;
import net.officefloor.frame.api.manage.Office;
import net.officefloor.frame.util.AbstractSingleTask;
import net.officefloor.plugin.servlet.container.HttpServletContainer;
import net.officefloor.plugin.servlet.container.HttpServletContainerImpl;
import net.officefloor.plugin.servlet.container.HttpServletServicer;
import net.officefloor.plugin.servlet.context.OfficeServletContext;
import net.officefloor.plugin.servlet.mapping.ServicerMapping;
import net.officefloor.plugin.servlet.security.HttpServletSecurity;
import net.officefloor.plugin.servlet.time.Clock;
import net.officefloor.plugin.socket.server.http.ServerHttpConnection;
import net.officefloor.plugin.web.http.application.HttpRequestState;
import net.officefloor.plugin.web.http.session.HttpSession;

public class HttpServletTask
extends AbstractSingleTask<HttpServletTask, DependencyKeys, None>
implements OfficeAwareWorkFactory<HttpServletTask>,
HttpServletServicer {
    public static final String PROPERTY_PREFIX_INIT_PARAMETER = "init.parameter.";
    public static final String PROPERTY_SERVLET_MAPPINGS = "servlet.mappings";
    public static final String TASK_NAME = "service";
    private static final Clock CLOCK = new Clock(){

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    };
    private final String servletName;
    private final HttpServlet servlet;
    private final Map<String, String> initParameters;
    private final String[] servletMappings;
    private Office office;
    private HttpServletContainer container = null;

    public static void sourceWork(WorkTypeBuilder<HttpServletTask> workTypeBuilder, WorkSourceContext context, String servletName, HttpServlet servlet, String ... servletMappings) {
        HashMap<String, String> initParameters = new HashMap<String, String>();
        for (String propertyName : context.getPropertyNames()) {
            if (!propertyName.startsWith(PROPERTY_PREFIX_INIT_PARAMETER)) continue;
            String parameterName = propertyName.substring(PROPERTY_PREFIX_INIT_PARAMETER.length());
            String parameterValue = context.getProperty(propertyName);
            initParameters.put(parameterName, parameterValue);
        }
        String servletMappingsText = context.getProperty(PROPERTY_SERVLET_MAPPINGS, null);
        if (servletMappingsText != null) {
            servletMappings = servletMappingsText.split(",");
            for (int i = 0; i < servletMappings.length; ++i) {
                servletMappings[i] = servletMappings[i].trim();
            }
        }
        HttpServletTask factory = new HttpServletTask(servletName, servlet, initParameters, servletMappings);
        workTypeBuilder.setWorkFactory((WorkFactory)factory);
        TaskTypeBuilder task = workTypeBuilder.addTaskType(TASK_NAME, (TaskFactory)factory, DependencyKeys.class, None.class);
        task.setDifferentiator((Object)factory);
        task.addObject(ServicerMapping.class).setKey((Enum)DependencyKeys.SERVICER_MAPPING);
        task.addObject(OfficeServletContext.class).setKey((Enum)DependencyKeys.OFFICE_SERVLET_CONTEXT);
        task.addObject(ServerHttpConnection.class).setKey((Enum)DependencyKeys.HTTP_CONNECTION);
        task.addObject(HttpRequestState.class).setKey((Enum)DependencyKeys.REQUEST_ATTRIBUTES);
        task.addObject(HttpSession.class).setKey((Enum)DependencyKeys.HTTP_SESSION);
        task.addObject(HttpServletSecurity.class).setKey((Enum)DependencyKeys.HTTP_SECURITY);
        task.addEscalation(ServletException.class);
        task.addEscalation(IOException.class);
    }

    public HttpServletTask(String servletName, HttpServlet servlet, Map<String, String> initParameters, String ... servletMappings) {
        this.servletName = servletName;
        this.servlet = servlet;
        this.initParameters = initParameters;
        this.servletMappings = servletMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpServletContainer getHttpServletContainer(OfficeServletContext officeServletContext) throws ServletException {
        HttpServletTask httpServletTask = this;
        synchronized (httpServletTask) {
            if (this.container == null) {
                Locale locale = Locale.getDefault();
                this.container = new HttpServletContainerImpl(this.servletName, this.servlet, this.initParameters, officeServletContext, this.office, CLOCK, locale);
            }
        }
        return this.container;
    }

    public void setOffice(Office office) throws Exception {
        this.office = office;
    }

    public Object doTask(TaskContext<HttpServletTask, DependencyKeys, None> context) throws ServletException, IOException {
        OfficeServletContext officeServletContext = (OfficeServletContext)context.getObject((Enum)DependencyKeys.OFFICE_SERVLET_CONTEXT);
        HttpServletContainer container = this.getHttpServletContainer(officeServletContext);
        ServerHttpConnection connection = (ServerHttpConnection)context.getObject((Enum)DependencyKeys.HTTP_CONNECTION);
        HttpRequestState attributes = (HttpRequestState)context.getObject((Enum)DependencyKeys.REQUEST_ATTRIBUTES);
        HttpSession session = (HttpSession)context.getObject((Enum)DependencyKeys.HTTP_SESSION);
        HttpServletSecurity security = (HttpServletSecurity)context.getObject((Enum)DependencyKeys.HTTP_SECURITY);
        ServicerMapping mapping = (ServicerMapping)context.getObject((Enum)DependencyKeys.SERVICER_MAPPING);
        container.service(connection, attributes, session, security, context, mapping);
        return null;
    }

    @Override
    public String getServletName() {
        return this.servletName;
    }

    @Override
    public String[] getServletMappings() {
        return this.servletMappings;
    }

    @Override
    public void include(OfficeServletContext context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServletContainer container = this.getHttpServletContainer(context);
        container.include(request, response);
    }

    public static enum DependencyKeys {
        SERVICER_MAPPING,
        OFFICE_SERVLET_CONTEXT,
        HTTP_CONNECTION,
        REQUEST_ATTRIBUTES,
        HTTP_SESSION,
        HTTP_SECURITY;

    }
}

