/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.container;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import net.officefloor.plugin.servlet.container.UnsupportedHttpServletMethodException;

public class HttpResponseServletOutputStream
extends ServletOutputStream {
    private final OutputStream delegate;
    private int bufferSize = 1024;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(this.bufferSize);
    private int bufferNestingLevel = 0;
    private boolean isCommitted = false;

    public HttpResponseServletOutputStream(OutputStream delegate) {
        this.delegate = delegate;
    }

    void ensureNotCommitted() throws IllegalStateException {
        if (this.isCommitted) {
            throw new IllegalStateException("Response has been committed");
        }
    }

    void setBufferSize(int size) throws IOException {
        this.ensureNotCommitted();
        this.bufferSize = size;
        this.commitFullBuffer();
    }

    int getBufferSize() {
        return this.bufferSize;
    }

    void bufferingContent() {
        ++this.bufferNestingLevel;
    }

    void contentBuffered() {
        --this.bufferNestingLevel;
    }

    void reset() {
        this.buffer.reset();
    }

    boolean isCommitted() {
        return this.isCommitted;
    }

    private void commitFullBuffer() throws IOException {
        if (this.buffer.size() >= this.bufferSize) {
            this.flush();
        }
    }

    public void write(int b) throws IOException {
        if (!this.isCommitted) {
            this.buffer.write(b);
            this.commitFullBuffer();
            return;
        }
        this.delegate.write(b);
    }

    public void flush() throws IOException {
        if (this.bufferNestingLevel > 0) {
            return;
        }
        if (!this.isCommitted) {
            this.buffer.writeTo(this.delegate);
        }
        this.isCommitted = true;
        this.delegate.flush();
    }

    public boolean isReady() {
        return (Boolean)UnsupportedHttpServletMethodException.notSupported();
    }

    public void setWriteListener(WriteListener writeListener) {
        UnsupportedHttpServletMethodException.notSupported();
    }
}

