/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.bridge;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.AsyncContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.officefloor.autowire.AutoWire;
import net.officefloor.autowire.AutoWireObject;
import net.officefloor.autowire.ManagedObjectSourceWirer;
import net.officefloor.autowire.ManagedObjectSourceWirerContext;
import net.officefloor.autowire.impl.AutoWireOfficeFloorSource;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.api.escalate.EscalationHandler;
import net.officefloor.frame.api.execute.TaskContext;
import net.officefloor.frame.api.manage.OfficeFloor;
import net.officefloor.frame.impl.spi.team.PassiveTeamSource;
import net.officefloor.frame.impl.spi.team.ProcessContextTeam;
import net.officefloor.frame.impl.spi.team.ProcessContextTeamSource;
import net.officefloor.frame.internal.structure.ManagedObjectScope;
import net.officefloor.frame.spi.managedobject.ManagedObject;
import net.officefloor.frame.spi.managedobject.recycle.RecycleManagedObjectParameter;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectExecuteContext;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectSourceContext;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractAsyncManagedObjectSource;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractManagedObjectSource;
import net.officefloor.frame.util.AbstractSingleTask;
import net.officefloor.plugin.servlet.bridge.ServletBridge;
import net.officefloor.plugin.servlet.bridge.spi.ServletServiceBridger;

public class ServletBridgeManagedObjectSource
extends AbstractManagedObjectSource<None, FlowKeys> {
    public static final String[] DEPENDENCY_ANNOTATION_TYPE_NAMES = new String[]{"javax.annotation.Resource", "javax.ejb.EJB"};
    public static final String PROPERTY_INSTANCE_IDENTIFIER = "instance.identifier";
    private static int nextInstanceIdentifier = 1;
    public static final String PROPERTY_USE_ASYNC = "use.async";
    private static Map<String, ServletBridgeManagedObjectSource> instances = new HashMap<String, ServletBridgeManagedObjectSource>();
    private ManagedObjectExecuteContext<FlowKeys> context;

    public static <S> ServletServiceBridger<S> createServletServiceBridger(Class<S> servletClass, AutoWireOfficeFloorSource source, final String handlerSectionName, final String handlerInputName) {
        ServletServiceBridger<S> bridger = ServletBridgeManagedObjectSource.createServletServiceBridger(servletClass);
        final boolean isUseAsync = bridger.isUseAsyncContext();
        AutoWireObject bridge = source.addManagedObject(ServletBridgeManagedObjectSource.class.getName(), new ManagedObjectSourceWirer(){

            public void wire(ManagedObjectSourceWirerContext context) {
                context.setManagedObjectScope(ManagedObjectScope.PROCESS);
                context.mapFlow(FlowKeys.SERVICE.name(), handlerSectionName, handlerInputName);
                if (isUseAsync) {
                    context.mapTeam("COMPLETE", PassiveTeamSource.class.getName());
                }
            }
        }, new AutoWire[]{new AutoWire(ServletBridge.class)});
        bridge.addProperty(PROPERTY_INSTANCE_IDENTIFIER, bridger.getInstanceIdentifier());
        bridge.addProperty(PROPERTY_USE_ASYNC, String.valueOf(isUseAsync));
        if (!isUseAsync) {
            source.assignDefaultTeam(ProcessContextTeamSource.class.getName());
        }
        return bridger;
    }

    public static synchronized <S> ServletServiceBridger<S> createServletServiceBridger(Class<S> servletClass) {
        String instanceIdentifier = String.valueOf(nextInstanceIdentifier++);
        HashMap injectedDependencies = new HashMap();
        for (Class<S> clazz = servletClass; clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                boolean isDependency = false;
                block2: for (Annotation annotation : field.getAnnotations()) {
                    String annotationTypeName = annotation.annotationType().getName();
                    for (String dependencyAnnotationTypeName : DEPENDENCY_ANNOTATION_TYPE_NAMES) {
                        if (!dependencyAnnotationTypeName.equals(annotationTypeName)) continue;
                        isDependency = true;
                        break block2;
                    }
                }
                if (!isDependency) continue;
                Class<?> dependencyType = field.getType();
                injectedDependencies.put(dependencyType, field);
            }
        }
        return new ServletServiceBridgerImpl(instanceIdentifier, injectedDependencies);
    }

    private static synchronized ServletBridgeManagedObjectSource getInstance(String instanceIdentifier) {
        return instances.get(instanceIdentifier);
    }

    protected void loadSpecification(AbstractAsyncManagedObjectSource.SpecificationContext context) {
        context.addProperty(PROPERTY_INSTANCE_IDENTIFIER, "Instance");
        context.addProperty(PROPERTY_USE_ASYNC, "Async");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadMetaData(AbstractAsyncManagedObjectSource.MetaDataContext<None, FlowKeys> context) throws Exception {
        ManagedObjectSourceContext mosContext = context.getManagedObjectSourceContext();
        String instanceIdentifier = mosContext.getProperty(PROPERTY_INSTANCE_IDENTIFIER);
        Class<ServletBridgeManagedObjectSource> clazz = ServletBridgeManagedObjectSource.class;
        synchronized (ServletBridgeManagedObjectSource.class) {
            instances.put(instanceIdentifier, this);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            context.setObjectClass(ServletBridge.class);
            context.addFlow((Enum)FlowKeys.SERVICE, null);
            boolean isUseAsync = Boolean.parseBoolean(mosContext.getProperty(PROPERTY_USE_ASYNC, String.valueOf(Boolean.FALSE)));
            if (isUseAsync) {
                CompleteAsyncContextTask recycleTask = new CompleteAsyncContextTask();
                recycleTask.registerAsRecycleTask(mosContext, "COMPLETE");
            }
            return;
        }
    }

    public void start(ManagedObjectExecuteContext<FlowKeys> context) throws Exception {
        this.context = context;
    }

    protected ManagedObject getManagedObject() throws Throwable {
        throw new IllegalStateException("Can not source managed object from a " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public static class CompleteAsyncContextTask
    extends AbstractSingleTask<CompleteAsyncContextTask, None, None> {
        public Object doTask(TaskContext<CompleteAsyncContextTask, None, None> context) {
            RecycleManagedObjectParameter parameter = this.getRecycleManagedObjectParameter(context, ServletBridgeManagedObject.class);
            ((ServletBridgeManagedObject)parameter.getManagedObject()).getAsyncContext().complete();
            return null;
        }
    }

    private static class ServletBridgeManagedObject
    implements ServletBridge,
    ManagedObject,
    EscalationHandler {
        private final ServletServiceBridgerImpl<?> bridger;
        private final Object servlet;
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final ServletContext servletContext;
        private final AsyncContext asyncContext;
        private volatile Throwable escalation = null;

        public ServletBridgeManagedObject(ServletServiceBridgerImpl<?> bridger, Object servlet, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, AsyncContext asyncContext) {
            this.bridger = bridger;
            this.servlet = servlet;
            this.request = request;
            this.response = response;
            this.servletContext = servletContext;
            this.asyncContext = asyncContext;
        }

        public void propagateException() throws IOException, ServletException {
            Throwable exception = this.escalation;
            if (exception == null) {
                return;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ServletException) {
                throw (ServletException)exception;
            }
            throw new ServletException(exception);
        }

        @Override
        public HttpServletRequest getRequest() {
            return this.request;
        }

        @Override
        public HttpServletResponse getResponse() {
            return this.response;
        }

        @Override
        public ServletContext getServletContext() {
            return this.servletContext;
        }

        @Override
        public AsyncContext getAsyncContext() {
            return this.asyncContext;
        }

        @Override
        public <O> O getObject(Class<? extends O> objectType) throws Exception {
            return (O)((ServletServiceBridgerImpl)this.bridger).getObject(this.servlet, objectType);
        }

        public Object getObject() throws Throwable {
            return this;
        }

        public void handleEscalation(Throwable escalation) throws Throwable {
            this.escalation = escalation;
            if (this.asyncContext != null) {
                try {
                    this.response.sendError(500, escalation.getMessage() + "[" + escalation.getClass().getSimpleName() + "]");
                }
                finally {
                    this.asyncContext.complete();
                }
            }
        }
    }

    private static class ServletServiceBridgerImpl<S>
    implements ServletServiceBridger<S> {
        private final String instanceIdentifier;
        private final Map<Class<?>, Field> injectedDependencies;

        public ServletServiceBridgerImpl(String instanceIdentifier, Map<Class<?>, Field> injectedDependencies) {
            this.instanceIdentifier = instanceIdentifier;
            this.injectedDependencies = injectedDependencies;
            for (Field field : this.injectedDependencies.values()) {
                field.setAccessible(true);
            }
        }

        private Object getObject(Object servlet, Class<?> objectType) throws Exception {
            Field field = this.injectedDependencies.get(objectType);
            if (field == null) {
                return null;
            }
            return field.get(servlet);
        }

        @Override
        public String getInstanceIdentifier() {
            return this.instanceIdentifier;
        }

        @Override
        public boolean isUseAsyncContext() {
            return this.injectedDependencies.size() == 0;
        }

        @Override
        public Class<?>[] getObjectTypes() {
            Set<Class<?>> types = this.injectedDependencies.keySet();
            return types.toArray(new Class[types.size()]);
        }

        @Override
        public void service(S servlet, HttpServletRequest request, HttpServletResponse response, ServletContext context) throws IOException, ServletException {
            ServletBridgeManagedObjectSource instance = ServletBridgeManagedObjectSource.getInstance(this.instanceIdentifier);
            if (instance == null) {
                throw new IllegalStateException("Instance " + this.instanceIdentifier + " is not within an open " + OfficeFloor.class.getSimpleName());
            }
            if (this.isUseAsyncContext()) {
                AsyncContext asyncContext = request.startAsync();
                ServletBridgeManagedObject managedObject = new ServletBridgeManagedObject(this, servlet, request, response, context, asyncContext);
                instance.context.invokeProcess((Enum)FlowKeys.SERVICE, null, (ManagedObject)managedObject, 0L, (EscalationHandler)managedObject);
            } else {
                ServletBridgeManagedObject managedObject = new ServletBridgeManagedObject(this, servlet, request, response, context, null);
                try {
                    ProcessContextTeam.doProcess((ManagedObjectExecuteContext)instance.context, (Enum)FlowKeys.SERVICE, null, (ManagedObject)managedObject, (EscalationHandler)managedObject);
                }
                catch (InterruptedException ex) {
                    throw new ServletException((Throwable)ex);
                }
                managedObject.propagateException();
            }
        }
    }

    public static enum FlowKeys {
        SERVICE;

    }
}

