/*
 * 
 */
package net.officefloor.plugin.servlet.webxml.model;

import java.util.List;
import java.util.LinkedList;

import javax.annotation.Generated;

import net.officefloor.model.AbstractModel;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.ItemModel;
import net.officefloor.model.RemoveConnectionsAction;

@Generated("net.officefloor.model.generate.ModelGenerator")
public class WebAppModel extends AbstractModel implements ItemModel<WebAppModel> {

    public static enum WebAppEvent {
     CHANGE_VERSION, CHANGE_DISPLAY_NAME, ADD_CONTEXT_PARAM, REMOVE_CONTEXT_PARAM, ADD_MIME_MAPPING, REMOVE_MIME_MAPPING, ADD_SERVLET, REMOVE_SERVLET, ADD_SERVLET_MAPPING, REMOVE_SERVLET_MAPPING, ADD_FILTER, REMOVE_FILTER, ADD_FILTER_MAPPING, REMOVE_FILTER_MAPPING
    }

    /**
     * Default constructor.
     */
    public WebAppModel() {
    }

    /**
     * Convenience constructor for new non-linked instance.
     *
     * @param version Version.
     * @param displayName Display name.
     */
    public WebAppModel(
      String version
    , String displayName
    ) {
        this.version = version;
        this.displayName = displayName;
    }

    /**
     * Convenience constructor.
     *
     * @param version Version.
     * @param displayName Display name.
     * @param contextParam Context param.
     * @param mimeMapping Mime mapping.
     * @param servlet Servlet.
     * @param servletMapping Servlet mapping.
     * @param filter Filter.
     * @param filterMapping Filter mapping.
     */
    public WebAppModel(
      String version
    , String displayName
    , ContextParamModel[] contextParam
    , MimeMappingModel[] mimeMapping
    , ServletModel[] servlet
    , ServletMappingModel[] servletMapping
    , FilterModel[] filter
    , FilterMappingModel[] filterMapping
    ) {
        this.version = version;
        this.displayName = displayName;
        if (contextParam != null) {
            for (ContextParamModel model : contextParam) {
                this.contextParam.add(model);
            }
        }
        if (mimeMapping != null) {
            for (MimeMappingModel model : mimeMapping) {
                this.mimeMapping.add(model);
            }
        }
        if (servlet != null) {
            for (ServletModel model : servlet) {
                this.servlet.add(model);
            }
        }
        if (servletMapping != null) {
            for (ServletMappingModel model : servletMapping) {
                this.servletMapping.add(model);
            }
        }
        if (filter != null) {
            for (FilterModel model : filter) {
                this.filter.add(model);
            }
        }
        if (filterMapping != null) {
            for (FilterMappingModel model : filterMapping) {
                this.filterMapping.add(model);
            }
        }
    }

    /**
     * Convenience constructor allowing XY initialising.
     *
     * @param version Version.
     * @param displayName Display name.
     * @param contextParam Context param.
     * @param mimeMapping Mime mapping.
     * @param servlet Servlet.
     * @param servletMapping Servlet mapping.
     * @param filter Filter.
     * @param filterMapping Filter mapping.
     * @param x Horizontal location.
     * @param y Vertical location.
     */
    public WebAppModel(
      String version
    , String displayName
    , ContextParamModel[] contextParam
    , MimeMappingModel[] mimeMapping
    , ServletModel[] servlet
    , ServletMappingModel[] servletMapping
    , FilterModel[] filter
    , FilterMappingModel[] filterMapping
    , int x
    , int y
    ) {
        this.version = version;
        this.displayName = displayName;
        if (contextParam != null) {
            for (ContextParamModel model : contextParam) {
                this.contextParam.add(model);
            }
        }
        if (mimeMapping != null) {
            for (MimeMappingModel model : mimeMapping) {
                this.mimeMapping.add(model);
            }
        }
        if (servlet != null) {
            for (ServletModel model : servlet) {
                this.servlet.add(model);
            }
        }
        if (servletMapping != null) {
            for (ServletMappingModel model : servletMapping) {
                this.servletMapping.add(model);
            }
        }
        if (filter != null) {
            for (FilterModel model : filter) {
                this.filter.add(model);
            }
        }
        if (filterMapping != null) {
            for (FilterMappingModel model : filterMapping) {
                this.filterMapping.add(model);
            }
        }
        this.setX(x);
        this.setY(y);
    }


    /**
     * Version.
     */
    private String version;

    /**
     * @return Version.
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * @param version Version.
     */
    public void setVersion(String version) {
        String oldValue = this.version;
        this.version = version;
        this.changeField(oldValue, this.version, WebAppEvent.CHANGE_VERSION);
    }


    /**
     * Display name.
     */
    private String displayName;

    /**
     * @return Display name.
     */
    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * @param displayName Display name.
     */
    public void setDisplayName(String displayName) {
        String oldValue = this.displayName;
        this.displayName = displayName;
        this.changeField(oldValue, this.displayName, WebAppEvent.CHANGE_DISPLAY_NAME);
    }


    /**
     * Context param.
     */
    private List<ContextParamModel> contextParam = new LinkedList<ContextParamModel>();

    /**
     * @return Context param.
     */
    public List<ContextParamModel> getContextParams() {
        return this.contextParam;
    }

    /**
     * @param contextParam Context param.
     */
    public void addContextParam(ContextParamModel contextParam) {
        this.addItemToList(contextParam, this.contextParam, WebAppEvent.ADD_CONTEXT_PARAM);
    }

    /**
     * @param contextParam Context param.
     */
    public void removeContextParam(ContextParamModel contextParam) {
        this.removeItemFromList(contextParam, this.contextParam, WebAppEvent.REMOVE_CONTEXT_PARAM);
    }


    /**
     * Mime mapping.
     */
    private List<MimeMappingModel> mimeMapping = new LinkedList<MimeMappingModel>();

    /**
     * @return Mime mapping.
     */
    public List<MimeMappingModel> getMimeMappings() {
        return this.mimeMapping;
    }

    /**
     * @param mimeMapping Mime mapping.
     */
    public void addMimeMapping(MimeMappingModel mimeMapping) {
        this.addItemToList(mimeMapping, this.mimeMapping, WebAppEvent.ADD_MIME_MAPPING);
    }

    /**
     * @param mimeMapping Mime mapping.
     */
    public void removeMimeMapping(MimeMappingModel mimeMapping) {
        this.removeItemFromList(mimeMapping, this.mimeMapping, WebAppEvent.REMOVE_MIME_MAPPING);
    }


    /**
     * Servlet.
     */
    private List<ServletModel> servlet = new LinkedList<ServletModel>();

    /**
     * @return Servlet.
     */
    public List<ServletModel> getServlets() {
        return this.servlet;
    }

    /**
     * @param servlet Servlet.
     */
    public void addServlet(ServletModel servlet) {
        this.addItemToList(servlet, this.servlet, WebAppEvent.ADD_SERVLET);
    }

    /**
     * @param servlet Servlet.
     */
    public void removeServlet(ServletModel servlet) {
        this.removeItemFromList(servlet, this.servlet, WebAppEvent.REMOVE_SERVLET);
    }


    /**
     * Servlet mapping.
     */
    private List<ServletMappingModel> servletMapping = new LinkedList<ServletMappingModel>();

    /**
     * @return Servlet mapping.
     */
    public List<ServletMappingModel> getServletMappings() {
        return this.servletMapping;
    }

    /**
     * @param servletMapping Servlet mapping.
     */
    public void addServletMapping(ServletMappingModel servletMapping) {
        this.addItemToList(servletMapping, this.servletMapping, WebAppEvent.ADD_SERVLET_MAPPING);
    }

    /**
     * @param servletMapping Servlet mapping.
     */
    public void removeServletMapping(ServletMappingModel servletMapping) {
        this.removeItemFromList(servletMapping, this.servletMapping, WebAppEvent.REMOVE_SERVLET_MAPPING);
    }


    /**
     * Filter.
     */
    private List<FilterModel> filter = new LinkedList<FilterModel>();

    /**
     * @return Filter.
     */
    public List<FilterModel> getFilters() {
        return this.filter;
    }

    /**
     * @param filter Filter.
     */
    public void addFilter(FilterModel filter) {
        this.addItemToList(filter, this.filter, WebAppEvent.ADD_FILTER);
    }

    /**
     * @param filter Filter.
     */
    public void removeFilter(FilterModel filter) {
        this.removeItemFromList(filter, this.filter, WebAppEvent.REMOVE_FILTER);
    }


    /**
     * Filter mapping.
     */
    private List<FilterMappingModel> filterMapping = new LinkedList<FilterMappingModel>();

    /**
     * @return Filter mapping.
     */
    public List<FilterMappingModel> getFilterMappings() {
        return this.filterMapping;
    }

    /**
     * @param filterMapping Filter mapping.
     */
    public void addFilterMapping(FilterMappingModel filterMapping) {
        this.addItemToList(filterMapping, this.filterMapping, WebAppEvent.ADD_FILTER_MAPPING);
    }

    /**
     * @param filterMapping Filter mapping.
     */
    public void removeFilterMapping(FilterMappingModel filterMapping) {
        this.removeItemFromList(filterMapping, this.filterMapping, WebAppEvent.REMOVE_FILTER_MAPPING);
    }


    /**
     * Remove Connections.
     *
     * @return {@link RemoveConnectionsAction} to remove the {@link ConnectionModel} instances.
     */
    public RemoveConnectionsAction<WebAppModel> removeConnections() {
        RemoveConnectionsAction<WebAppModel> _action = new RemoveConnectionsAction<WebAppModel>(this);
        return _action;
    }
}
