/*
 * 
 */
package net.officefloor.plugin.servlet.webxml.model;

import java.util.List;
import java.util.LinkedList;

import javax.annotation.Generated;

import net.officefloor.model.AbstractModel;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.ItemModel;
import net.officefloor.model.RemoveConnectionsAction;

@Generated("net.officefloor.model.generate.ModelGenerator")
public class ServletModel extends AbstractModel implements ItemModel<ServletModel> {

    public static enum ServletEvent {
     CHANGE_SERVLET_NAME, CHANGE_SERVLET_CLASS, ADD_INIT_PARAM, REMOVE_INIT_PARAM
    }

    /**
     * Default constructor.
     */
    public ServletModel() {
    }

    /**
     * Convenience constructor for new non-linked instance.
     *
     * @param servletName Servlet name.
     * @param servletClass Servlet class.
     */
    public ServletModel(
      String servletName
    , String servletClass
    ) {
        this.servletName = servletName;
        this.servletClass = servletClass;
    }

    /**
     * Convenience constructor.
     *
     * @param servletName Servlet name.
     * @param servletClass Servlet class.
     * @param initParam Init param.
     */
    public ServletModel(
      String servletName
    , String servletClass
    , InitParamModel[] initParam
    ) {
        this.servletName = servletName;
        this.servletClass = servletClass;
        if (initParam != null) {
            for (InitParamModel model : initParam) {
                this.initParam.add(model);
            }
        }
    }

    /**
     * Convenience constructor allowing XY initialising.
     *
     * @param servletName Servlet name.
     * @param servletClass Servlet class.
     * @param initParam Init param.
     * @param x Horizontal location.
     * @param y Vertical location.
     */
    public ServletModel(
      String servletName
    , String servletClass
    , InitParamModel[] initParam
    , int x
    , int y
    ) {
        this.servletName = servletName;
        this.servletClass = servletClass;
        if (initParam != null) {
            for (InitParamModel model : initParam) {
                this.initParam.add(model);
            }
        }
        this.setX(x);
        this.setY(y);
    }


    /**
     * Servlet name.
     */
    private String servletName;

    /**
     * @return Servlet name.
     */
    public String getServletName() {
        return this.servletName;
    }

    /**
     * @param servletName Servlet name.
     */
    public void setServletName(String servletName) {
        String oldValue = this.servletName;
        this.servletName = servletName;
        this.changeField(oldValue, this.servletName, ServletEvent.CHANGE_SERVLET_NAME);
    }


    /**
     * Servlet class.
     */
    private String servletClass;

    /**
     * @return Servlet class.
     */
    public String getServletClass() {
        return this.servletClass;
    }

    /**
     * @param servletClass Servlet class.
     */
    public void setServletClass(String servletClass) {
        String oldValue = this.servletClass;
        this.servletClass = servletClass;
        this.changeField(oldValue, this.servletClass, ServletEvent.CHANGE_SERVLET_CLASS);
    }


    /**
     * Init param.
     */
    private List<InitParamModel> initParam = new LinkedList<InitParamModel>();

    /**
     * @return Init param.
     */
    public List<InitParamModel> getInitParams() {
        return this.initParam;
    }

    /**
     * @param initParam Init param.
     */
    public void addInitParam(InitParamModel initParam) {
        this.addItemToList(initParam, this.initParam, ServletEvent.ADD_INIT_PARAM);
    }

    /**
     * @param initParam Init param.
     */
    public void removeInitParam(InitParamModel initParam) {
        this.removeItemFromList(initParam, this.initParam, ServletEvent.REMOVE_INIT_PARAM);
    }


    /**
     * Remove Connections.
     *
     * @return {@link RemoveConnectionsAction} to remove the {@link ConnectionModel} instances.
     */
    public RemoveConnectionsAction<ServletModel> removeConnections() {
        RemoveConnectionsAction<ServletModel> _action = new RemoveConnectionsAction<ServletModel>(this);
        return _action;
    }
}
