/*
 * 
 */
package net.officefloor.plugin.servlet.webxml.model;

import java.util.List;
import java.util.LinkedList;

import javax.annotation.Generated;

import net.officefloor.model.AbstractModel;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.ItemModel;
import net.officefloor.model.RemoveConnectionsAction;

@Generated("net.officefloor.model.generate.ModelGenerator")
public class ServletMappingModel extends AbstractModel implements ItemModel<ServletMappingModel> {

    public static enum ServletMappingEvent {
     CHANGE_SERVLET_NAME, ADD_URL_PATTERN, REMOVE_URL_PATTERN
    }

    /**
     * Default constructor.
     */
    public ServletMappingModel() {
    }

    /**
     * Convenience constructor.
     *
     * @param servletName Servlet name.
     * @param urlPattern Url pattern.
     */
    public ServletMappingModel(
      String servletName
    , String[] urlPattern
    ) {
        this.servletName = servletName;
        if (urlPattern != null) {
            for (String model : urlPattern) {
                this.urlPattern.add(model);
            }
        }
    }

    /**
     * Convenience constructor allowing XY initialising.
     *
     * @param servletName Servlet name.
     * @param urlPattern Url pattern.
     * @param x Horizontal location.
     * @param y Vertical location.
     */
    public ServletMappingModel(
      String servletName
    , String[] urlPattern
    , int x
    , int y
    ) {
        this.servletName = servletName;
        if (urlPattern != null) {
            for (String model : urlPattern) {
                this.urlPattern.add(model);
            }
        }
        this.setX(x);
        this.setY(y);
    }


    /**
     * Servlet name.
     */
    private String servletName;

    /**
     * @return Servlet name.
     */
    public String getServletName() {
        return this.servletName;
    }

    /**
     * @param servletName Servlet name.
     */
    public void setServletName(String servletName) {
        String oldValue = this.servletName;
        this.servletName = servletName;
        this.changeField(oldValue, this.servletName, ServletMappingEvent.CHANGE_SERVLET_NAME);
    }


    /**
     * Url pattern.
     */
    private List<String> urlPattern = new LinkedList<String>();

    /**
     * @return Url pattern.
     */
    public List<String> getUrlPatterns() {
        return this.urlPattern;
    }

    /**
     * @param urlPattern Url pattern.
     */
    public void addUrlPattern(String urlPattern) {
        this.addItemToList(urlPattern, this.urlPattern, ServletMappingEvent.ADD_URL_PATTERN);
    }

    /**
     * @param urlPattern Url pattern.
     */
    public void removeUrlPattern(String urlPattern) {
        this.removeItemFromList(urlPattern, this.urlPattern, ServletMappingEvent.REMOVE_URL_PATTERN);
    }


    /**
     * Remove Connections.
     *
     * @return {@link RemoveConnectionsAction} to remove the {@link ConnectionModel} instances.
     */
    public RemoveConnectionsAction<ServletMappingModel> removeConnections() {
        RemoveConnectionsAction<ServletMappingModel> _action = new RemoveConnectionsAction<ServletMappingModel>(this);
        return _action;
    }
}
