/*
 * 
 */
package net.officefloor.plugin.servlet.webxml.model;

import javax.annotation.Generated;

import net.officefloor.model.AbstractModel;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.ItemModel;
import net.officefloor.model.RemoveConnectionsAction;

@Generated("net.officefloor.model.generate.ModelGenerator")
public class MimeMappingModel extends AbstractModel implements ItemModel<MimeMappingModel> {

    public static enum MimeMappingEvent {
     CHANGE_EXTENSION, CHANGE_MIME_TYPE
    }

    /**
     * Default constructor.
     */
    public MimeMappingModel() {
    }

    /**
     * Convenience constructor.
     *
     * @param extension Extension.
     * @param mimeType Mime type.
     */
    public MimeMappingModel(
      String extension
    , String mimeType
    ) {
        this.extension = extension;
        this.mimeType = mimeType;
    }

    /**
     * Convenience constructor allowing XY initialising.
     *
     * @param extension Extension.
     * @param mimeType Mime type.
     * @param x Horizontal location.
     * @param y Vertical location.
     */
    public MimeMappingModel(
      String extension
    , String mimeType
    , int x
    , int y
    ) {
        this.extension = extension;
        this.mimeType = mimeType;
        this.setX(x);
        this.setY(y);
    }


    /**
     * Extension.
     */
    private String extension;

    /**
     * @return Extension.
     */
    public String getExtension() {
        return this.extension;
    }

    /**
     * @param extension Extension.
     */
    public void setExtension(String extension) {
        String oldValue = this.extension;
        this.extension = extension;
        this.changeField(oldValue, this.extension, MimeMappingEvent.CHANGE_EXTENSION);
    }


    /**
     * Mime type.
     */
    private String mimeType;

    /**
     * @return Mime type.
     */
    public String getMimeType() {
        return this.mimeType;
    }

    /**
     * @param mimeType Mime type.
     */
    public void setMimeType(String mimeType) {
        String oldValue = this.mimeType;
        this.mimeType = mimeType;
        this.changeField(oldValue, this.mimeType, MimeMappingEvent.CHANGE_MIME_TYPE);
    }


    /**
     * Remove Connections.
     *
     * @return {@link RemoveConnectionsAction} to remove the {@link ConnectionModel} instances.
     */
    public RemoveConnectionsAction<MimeMappingModel> removeConnections() {
        RemoveConnectionsAction<MimeMappingModel> _action = new RemoveConnectionsAction<MimeMappingModel>(this);
        return _action;
    }
}
