/*
 * 
 */
package net.officefloor.plugin.servlet.webxml.model;

import javax.annotation.Generated;

import net.officefloor.model.AbstractModel;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.ItemModel;
import net.officefloor.model.RemoveConnectionsAction;

@Generated("net.officefloor.model.generate.ModelGenerator")
public class InitParamModel extends AbstractModel implements ItemModel<InitParamModel> {

    public static enum InitParamEvent {
     CHANGE_NAME, CHANGE_VALUE
    }

    /**
     * Default constructor.
     */
    public InitParamModel() {
    }

    /**
     * Convenience constructor.
     *
     * @param name Name.
     * @param value Value.
     */
    public InitParamModel(
      String name
    , String value
    ) {
        this.name = name;
        this.value = value;
    }

    /**
     * Convenience constructor allowing XY initialising.
     *
     * @param name Name.
     * @param value Value.
     * @param x Horizontal location.
     * @param y Vertical location.
     */
    public InitParamModel(
      String name
    , String value
    , int x
    , int y
    ) {
        this.name = name;
        this.value = value;
        this.setX(x);
        this.setY(y);
    }


    /**
     * Name.
     */
    private String name;

    /**
     * @return Name.
     */
    public String getName() {
        return this.name;
    }

    /**
     * @param name Name.
     */
    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.changeField(oldValue, this.name, InitParamEvent.CHANGE_NAME);
    }


    /**
     * Value.
     */
    private String value;

    /**
     * @return Value.
     */
    public String getValue() {
        return this.value;
    }

    /**
     * @param value Value.
     */
    public void setValue(String value) {
        String oldValue = this.value;
        this.value = value;
        this.changeField(oldValue, this.value, InitParamEvent.CHANGE_VALUE);
    }


    /**
     * Remove Connections.
     *
     * @return {@link RemoveConnectionsAction} to remove the {@link ConnectionModel} instances.
     */
    public RemoveConnectionsAction<InitParamModel> removeConnections() {
        RemoveConnectionsAction<InitParamModel> _action = new RemoveConnectionsAction<InitParamModel>(this);
        return _action;
    }
}
