/*
 * 
 */
package net.officefloor.plugin.servlet.webxml.model;

import java.util.List;
import java.util.LinkedList;

import javax.annotation.Generated;

import net.officefloor.model.AbstractModel;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.ItemModel;
import net.officefloor.model.RemoveConnectionsAction;

@Generated("net.officefloor.model.generate.ModelGenerator")
public class FilterModel extends AbstractModel implements ItemModel<FilterModel> {

    public static enum FilterEvent {
     CHANGE_FILTER_NAME, CHANGE_FILTER_CLASS, ADD_INIT_PARAM, REMOVE_INIT_PARAM
    }

    /**
     * Default constructor.
     */
    public FilterModel() {
    }

    /**
     * Convenience constructor for new non-linked instance.
     *
     * @param filterName Filter name.
     * @param filterClass Filter class.
     */
    public FilterModel(
      String filterName
    , String filterClass
    ) {
        this.filterName = filterName;
        this.filterClass = filterClass;
    }

    /**
     * Convenience constructor.
     *
     * @param filterName Filter name.
     * @param filterClass Filter class.
     * @param initParam Init param.
     */
    public FilterModel(
      String filterName
    , String filterClass
    , InitParamModel[] initParam
    ) {
        this.filterName = filterName;
        this.filterClass = filterClass;
        if (initParam != null) {
            for (InitParamModel model : initParam) {
                this.initParam.add(model);
            }
        }
    }

    /**
     * Convenience constructor allowing XY initialising.
     *
     * @param filterName Filter name.
     * @param filterClass Filter class.
     * @param initParam Init param.
     * @param x Horizontal location.
     * @param y Vertical location.
     */
    public FilterModel(
      String filterName
    , String filterClass
    , InitParamModel[] initParam
    , int x
    , int y
    ) {
        this.filterName = filterName;
        this.filterClass = filterClass;
        if (initParam != null) {
            for (InitParamModel model : initParam) {
                this.initParam.add(model);
            }
        }
        this.setX(x);
        this.setY(y);
    }


    /**
     * Filter name.
     */
    private String filterName;

    /**
     * @return Filter name.
     */
    public String getFilterName() {
        return this.filterName;
    }

    /**
     * @param filterName Filter name.
     */
    public void setFilterName(String filterName) {
        String oldValue = this.filterName;
        this.filterName = filterName;
        this.changeField(oldValue, this.filterName, FilterEvent.CHANGE_FILTER_NAME);
    }


    /**
     * Filter class.
     */
    private String filterClass;

    /**
     * @return Filter class.
     */
    public String getFilterClass() {
        return this.filterClass;
    }

    /**
     * @param filterClass Filter class.
     */
    public void setFilterClass(String filterClass) {
        String oldValue = this.filterClass;
        this.filterClass = filterClass;
        this.changeField(oldValue, this.filterClass, FilterEvent.CHANGE_FILTER_CLASS);
    }


    /**
     * Init param.
     */
    private List<InitParamModel> initParam = new LinkedList<InitParamModel>();

    /**
     * @return Init param.
     */
    public List<InitParamModel> getInitParams() {
        return this.initParam;
    }

    /**
     * @param initParam Init param.
     */
    public void addInitParam(InitParamModel initParam) {
        this.addItemToList(initParam, this.initParam, FilterEvent.ADD_INIT_PARAM);
    }

    /**
     * @param initParam Init param.
     */
    public void removeInitParam(InitParamModel initParam) {
        this.removeItemFromList(initParam, this.initParam, FilterEvent.REMOVE_INIT_PARAM);
    }


    /**
     * Remove Connections.
     *
     * @return {@link RemoveConnectionsAction} to remove the {@link ConnectionModel} instances.
     */
    public RemoveConnectionsAction<FilterModel> removeConnections() {
        RemoveConnectionsAction<FilterModel> _action = new RemoveConnectionsAction<FilterModel>(this);
        return _action;
    }
}
