/*
 * 
 */
package net.officefloor.plugin.servlet.webxml.model;

import java.util.List;
import java.util.LinkedList;

import javax.annotation.Generated;

import net.officefloor.model.AbstractModel;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.ItemModel;
import net.officefloor.model.RemoveConnectionsAction;

@Generated("net.officefloor.model.generate.ModelGenerator")
public class FilterMappingModel extends AbstractModel implements ItemModel<FilterMappingModel> {

    public static enum FilterMappingEvent {
     CHANGE_FILTER_NAME, ADD_URL_PATTERN, REMOVE_URL_PATTERN, ADD_SERVLET_NAME, REMOVE_SERVLET_NAME, ADD_DISPATCHER, REMOVE_DISPATCHER
    }

    /**
     * Default constructor.
     */
    public FilterMappingModel() {
    }

    /**
     * Convenience constructor.
     *
     * @param filterName Filter name.
     * @param urlPattern Url pattern.
     * @param servletName Servlet name.
     * @param dispatcher Dispatcher.
     */
    public FilterMappingModel(
      String filterName
    , String[] urlPattern
    , String[] servletName
    , String[] dispatcher
    ) {
        this.filterName = filterName;
        if (urlPattern != null) {
            for (String model : urlPattern) {
                this.urlPattern.add(model);
            }
        }
        if (servletName != null) {
            for (String model : servletName) {
                this.servletName.add(model);
            }
        }
        if (dispatcher != null) {
            for (String model : dispatcher) {
                this.dispatcher.add(model);
            }
        }
    }

    /**
     * Convenience constructor allowing XY initialising.
     *
     * @param filterName Filter name.
     * @param urlPattern Url pattern.
     * @param servletName Servlet name.
     * @param dispatcher Dispatcher.
     * @param x Horizontal location.
     * @param y Vertical location.
     */
    public FilterMappingModel(
      String filterName
    , String[] urlPattern
    , String[] servletName
    , String[] dispatcher
    , int x
    , int y
    ) {
        this.filterName = filterName;
        if (urlPattern != null) {
            for (String model : urlPattern) {
                this.urlPattern.add(model);
            }
        }
        if (servletName != null) {
            for (String model : servletName) {
                this.servletName.add(model);
            }
        }
        if (dispatcher != null) {
            for (String model : dispatcher) {
                this.dispatcher.add(model);
            }
        }
        this.setX(x);
        this.setY(y);
    }


    /**
     * Filter name.
     */
    private String filterName;

    /**
     * @return Filter name.
     */
    public String getFilterName() {
        return this.filterName;
    }

    /**
     * @param filterName Filter name.
     */
    public void setFilterName(String filterName) {
        String oldValue = this.filterName;
        this.filterName = filterName;
        this.changeField(oldValue, this.filterName, FilterMappingEvent.CHANGE_FILTER_NAME);
    }


    /**
     * Url pattern.
     */
    private List<String> urlPattern = new LinkedList<String>();

    /**
     * @return Url pattern.
     */
    public List<String> getUrlPatterns() {
        return this.urlPattern;
    }

    /**
     * @param urlPattern Url pattern.
     */
    public void addUrlPattern(String urlPattern) {
        this.addItemToList(urlPattern, this.urlPattern, FilterMappingEvent.ADD_URL_PATTERN);
    }

    /**
     * @param urlPattern Url pattern.
     */
    public void removeUrlPattern(String urlPattern) {
        this.removeItemFromList(urlPattern, this.urlPattern, FilterMappingEvent.REMOVE_URL_PATTERN);
    }


    /**
     * Servlet name.
     */
    private List<String> servletName = new LinkedList<String>();

    /**
     * @return Servlet name.
     */
    public List<String> getServletNames() {
        return this.servletName;
    }

    /**
     * @param servletName Servlet name.
     */
    public void addServletName(String servletName) {
        this.addItemToList(servletName, this.servletName, FilterMappingEvent.ADD_SERVLET_NAME);
    }

    /**
     * @param servletName Servlet name.
     */
    public void removeServletName(String servletName) {
        this.removeItemFromList(servletName, this.servletName, FilterMappingEvent.REMOVE_SERVLET_NAME);
    }


    /**
     * Dispatcher.
     */
    private List<String> dispatcher = new LinkedList<String>();

    /**
     * @return Dispatcher.
     */
    public List<String> getDispatchers() {
        return this.dispatcher;
    }

    /**
     * @param dispatcher Dispatcher.
     */
    public void addDispatcher(String dispatcher) {
        this.addItemToList(dispatcher, this.dispatcher, FilterMappingEvent.ADD_DISPATCHER);
    }

    /**
     * @param dispatcher Dispatcher.
     */
    public void removeDispatcher(String dispatcher) {
        this.removeItemFromList(dispatcher, this.dispatcher, FilterMappingEvent.REMOVE_DISPATCHER);
    }


    /**
     * Remove Connections.
     *
     * @return {@link RemoveConnectionsAction} to remove the {@link ConnectionModel} instances.
     */
    public RemoveConnectionsAction<FilterMappingModel> removeConnections() {
        RemoveConnectionsAction<FilterMappingModel> _action = new RemoveConnectionsAction<FilterMappingModel>(this);
        return _action;
    }
}
