/*
 * 
 */
package net.officefloor.plugin.servlet.webxml.model;

import java.util.List;
import java.util.LinkedList;

import javax.annotation.Generated;

import net.officefloor.model.AbstractModel;
import net.officefloor.model.ItemModel;
import net.officefloor.model.RemoveConnectionsAction;

@Generated("net.officefloor.model.generate.ModelGenerator")
public class ServletMappingModel extends AbstractModel implements ItemModel<ServletMappingModel> {

    public static enum ServletMappingEvent {
     CHANGE_SERVLET_NAME, ADD_URL_PATTERN, REMOVE_URL_PATTERN
    }

    /**
     * Default constructor.
     */
    public ServletMappingModel() {
    }

    /**
     * Convenience constructor.
     */
    public ServletMappingModel(
      String servletName
    , String[] urlPattern
    ) {
        this.servletName = servletName;
        if (urlPattern != null) {
            for (String model : urlPattern) {
                this.urlPattern.add(model);
            }
        }
    }

    /**
     * Convenience constructor allowing XY initialising.
     */
    public ServletMappingModel(
      String servletName
    , String[] urlPattern
    , int x
    , int y
    ) {
        this.servletName = servletName;
        if (urlPattern != null) {
            for (String model : urlPattern) {
                this.urlPattern.add(model);
            }
        }
        this.setX(x);
        this.setY(y);
    }

    /**
     * Servlet name.
     */
    private String servletName;

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        String oldValue = this.servletName;
        this.servletName = servletName;
        this.changeField(oldValue, this.servletName, ServletMappingEvent.CHANGE_SERVLET_NAME);
    }


    /**
     * Url pattern.
     */
    private List<String> urlPattern = new LinkedList<String>();

    public List<String> getUrlPatterns() {
        return this.urlPattern;
    }

    public void addUrlPattern(String urlPattern) {
        this.addItemToList(urlPattern, this.urlPattern, ServletMappingEvent.ADD_URL_PATTERN);
    }

    public void removeUrlPattern(String urlPattern) {
        this.removeItemFromList(urlPattern, this.urlPattern, ServletMappingEvent.REMOVE_URL_PATTERN);
    }


    /**
     * Remove Connections.
     */
    public RemoveConnectionsAction<ServletMappingModel> removeConnections() {
        RemoveConnectionsAction<ServletMappingModel> _action = new RemoveConnectionsAction<ServletMappingModel>(this);
        return _action;
    }
}
