/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.web.http.session;

import net.officefloor.frame.api.build.None;
import net.officefloor.frame.spi.managedobject.CoordinatingManagedObject;
import net.officefloor.frame.spi.managedobject.ManagedObject;
import net.officefloor.frame.spi.managedobject.ObjectRegistry;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectSourceContext;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractAsyncManagedObjectSource;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractManagedObjectSource;
import net.officefloor.plugin.servlet.bridge.ServletBridge;
import net.officefloor.plugin.servlet.time.Clock;
import net.officefloor.plugin.servlet.web.http.session.ServletHttpSession;
import net.officefloor.plugin.web.http.session.HttpSession;

public class ServletHttpSessionManagedObjectSource
extends AbstractManagedObjectSource<DependencyKeys, None> {
    private static final Clock CLOCK = new Clock(){

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    };
    private String sessionTokenName;

    protected void loadSpecification(AbstractAsyncManagedObjectSource.SpecificationContext context) {
    }

    protected void loadMetaData(AbstractAsyncManagedObjectSource.MetaDataContext<DependencyKeys, None> context) throws Exception {
        ManagedObjectSourceContext mosContext = context.getManagedObjectSourceContext();
        this.sessionTokenName = mosContext.getProperty("session.id.cookie.name", "jsessionid");
        context.setObjectClass(HttpSession.class);
        context.setManagedObjectClass(ServletHttpSessionManagedObject.class);
        context.addDependency((Enum)DependencyKeys.SERVLET_BRIDGE, ServletBridge.class);
    }

    protected ManagedObject getManagedObject() throws Throwable {
        return new ServletHttpSessionManagedObject();
    }

    public class ServletHttpSessionManagedObject
    implements CoordinatingManagedObject<DependencyKeys> {
        private ServletHttpSession session;

        public void loadObjects(ObjectRegistry<DependencyKeys> registry) throws Throwable {
            ServletBridge bridge = (ServletBridge)registry.getObject((Enum)DependencyKeys.SERVLET_BRIDGE);
            this.session = new ServletHttpSession(bridge.getRequest().getSession(), CLOCK, ServletHttpSessionManagedObjectSource.this.sessionTokenName);
        }

        public Object getObject() throws Throwable {
            return this.session;
        }
    }

    public static enum DependencyKeys {
        SERVLET_BRIDGE;

    }
}

