/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.mapping;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.officefloor.plugin.servlet.container.HttpServletServicer;
import net.officefloor.plugin.servlet.mapping.ServicerMapper;
import net.officefloor.plugin.servlet.mapping.ServicerMapping;
import net.officefloor.plugin.servlet.mapping.ServicerMappingImpl;
import net.officefloor.plugin.web.http.tokenise.HttpRequestTokenHandler;
import net.officefloor.plugin.web.http.tokenise.HttpRequestTokeniseException;
import net.officefloor.plugin.web.http.tokenise.HttpRequestTokeniser;
import net.officefloor.plugin.web.http.tokenise.HttpRequestTokeniserImpl;

public class ServicerMapperImpl
implements ServicerMapper {
    private static HttpRequestTokeniser tokeniser = new HttpRequestTokeniserImpl();
    private static final char PATH_SEPARATOR_CHAR = '/';
    private static final String PATH_SEPARATOR = new String(new char[]{'/'});
    private static final String WILDCARD = "*";
    private static final int PRIORITY_EXACT = 0;
    private static final int PRIORITY_PATH = 1;
    private static final int PRIORITY_EXTENSION = 2;
    private static final int PRIORITY_DEFAULT = 3;
    private final Map<String, HttpServletServicer> namedServicers = new HashMap<String, HttpServletServicer>();
    private final Mapper[] mappers = new Mapper[4];

    public ServicerMapperImpl(HttpServletServicer ... servicers) {
        for (HttpServletServicer servicer : servicers) {
            String[] expressions;
            String servletName = servicer.getServletName();
            if (servletName != null) {
                this.namedServicers.put(servletName, servicer);
            }
            if ((expressions = servicer.getServletMappings()) == null) continue;
            for (String expression : expressions) {
                Mapper mapper = PATH_SEPARATOR.equals(expression) ? this.getMapper(3) : (expression.endsWith(WILDCARD) ? this.getMapper(1) : (expression.startsWith(WILDCARD) ? this.getMapper(2) : this.getMapper(0)));
                mapper.loadServicer(expression, servicer);
            }
        }
    }

    private Mapper getMapper(int priority) {
        Mapper mapper = this.mappers[priority];
        if (mapper == null) {
            switch (priority) {
                case 0: {
                    mapper = new ExactMapper();
                    break;
                }
                case 1: {
                    mapper = new PathMapper();
                    break;
                }
                case 2: {
                    mapper = new ExtensionMapper();
                    break;
                }
                case 3: {
                    mapper = new DefaultMapper();
                }
            }
            this.mappers[priority] = mapper;
        }
        return mapper;
    }

    @Override
    public ServicerMapping mapPath(String path) {
        Mapping mapping;
        try {
            mapping = new Mapping(path);
        }
        catch (HttpRequestTokeniseException ex) {
            return null;
        }
        for (int i = 0; i < this.mappers.length; ++i) {
            ServicerMapping servicerMapping;
            Mapper mapper = this.mappers[i];
            if (mapper == null || (servicerMapping = mapper.mapPath(mapping)) == null) continue;
            return servicerMapping;
        }
        return null;
    }

    @Override
    public HttpServletServicer mapName(String name) {
        return this.namedServicers.get(name);
    }

    private static class DefaultMapper
    implements Mapper {
        private HttpServletServicer defaultServicer;

        private DefaultMapper() {
        }

        @Override
        public int getPriority() {
            return 3;
        }

        @Override
        public void loadServicer(String mapping, HttpServletServicer servicer) {
            this.defaultServicer = servicer;
        }

        @Override
        public ServicerMapping mapPath(Mapping mapping) {
            return mapping.createServicerMapping("", mapping.getPath(), this.defaultServicer);
        }

        @Override
        public void mapAll(Mapping mapping, List<HttpServletServicer> servicers) {
            servicers.add(this.defaultServicer);
        }
    }

    private static class ExtensionMapper
    implements Mapper {
        private final Map<String, HttpServletServicer> extensionServicers = new HashMap<String, HttpServletServicer>();

        private ExtensionMapper() {
        }

        @Override
        public int getPriority() {
            return 2;
        }

        @Override
        public void loadServicer(String mapping, HttpServletServicer servicer) {
            mapping = mapping.substring(ServicerMapperImpl.WILDCARD.length());
            String DOT = ".";
            if (mapping.startsWith(".")) {
                mapping = mapping.substring(".".length());
            }
            String extension = mapping.toLowerCase();
            this.extensionServicers.put(extension, servicer);
        }

        @Override
        public ServicerMapping mapPath(Mapping mapping) {
            String extension = this.getExtension(mapping);
            if (extension == null) {
                return null;
            }
            HttpServletServicer servicer = this.extensionServicers.get(extension);
            if (servicer == null) {
                return null;
            }
            return mapping.createServicerMapping(mapping.getPath(), null, servicer);
        }

        @Override
        public void mapAll(Mapping mapping, List<HttpServletServicer> servicers) {
            String extension = this.getExtension(mapping);
            if (extension == null) {
                return;
            }
            HttpServletServicer servicer = this.extensionServicers.get(extension);
            if (servicer != null) {
                servicers.add(servicer);
            }
        }

        private String getExtension(Mapping mapping) {
            String path = mapping.getPath();
            int dotIndex = path.lastIndexOf(46);
            if (dotIndex < 0) {
                return null;
            }
            String extension = path.substring(dotIndex + 1);
            extension = extension.toLowerCase();
            return extension;
        }
    }

    private static class PathNode {
        private final String fullPath;
        private final Map<String, PathNode> children = new HashMap<String, PathNode>();
        public HttpServletServicer servicer = null;

        public PathNode(String fullPath) {
            this.fullPath = fullPath;
        }

        public PathNode loadChild(String segment) {
            PathNode child = this.children.get(segment);
            if (child == null) {
                child = new PathNode(this.fullPath + PATH_SEPARATOR + segment);
                this.children.put(segment, child);
            }
            return child;
        }

        public PathNode getChild(String segment) {
            return this.children.get(segment);
        }
    }

    private static class PathMapper
    implements Mapper {
        private final PathNode root = new PathNode("");

        private PathMapper() {
        }

        @Override
        public int getPriority() {
            return 1;
        }

        @Override
        public void loadServicer(String mapping, HttpServletServicer servicer) {
            if ((mapping = mapping.substring(0, mapping.length() - ServicerMapperImpl.WILDCARD.length())).startsWith(PATH_SEPARATOR)) {
                mapping = mapping.substring(PATH_SEPARATOR.length());
            }
            if (mapping.endsWith(PATH_SEPARATOR)) {
                mapping = mapping.substring(0, mapping.length() - PATH_SEPARATOR.length());
            }
            String[] segments = mapping.split(PATH_SEPARATOR);
            PathNode node = this.root;
            for (String segment : segments) {
                if (segment.length() == 0) continue;
                node = node.loadChild(segment);
            }
            node.servicer = servicer;
        }

        @Override
        public ServicerMapping mapPath(Mapping mapping) {
            String path = mapping.getPath();
            PathNode current = this.root;
            PathNode match = current.servicer == null ? null : current;
            int startIndex = 0;
            int lastIndex = path.length() - 1;
            int matchIndex = startIndex;
            for (int i = startIndex; i <= lastIndex; ++i) {
                char character = path.charAt(i);
                if (character != '/' && i != lastIndex) continue;
                if (i == startIndex) {
                    startIndex = i + 1;
                    continue;
                }
                int endIndex = i;
                if (character != '/') {
                    ++endIndex;
                }
                String segment = path.substring(startIndex, endIndex);
                startIndex = i + 1;
                if ((current = current.getChild(segment)) == null) break;
                if (current.servicer == null) continue;
                match = current;
                matchIndex = startIndex;
            }
            if (match == null) {
                return null;
            }
            String pathInfo = matchIndex >= path.length() ? null : PATH_SEPARATOR + path.substring(matchIndex);
            return mapping.createServicerMapping(match.fullPath, pathInfo, match.servicer);
        }

        @Override
        public void mapAll(Mapping mapping, List<HttpServletServicer> servicers) {
            String path = mapping.getPath();
            PathNode current = this.root;
            int startIndex = 0;
            int lastIndex = path.length() - 1;
            for (int i = startIndex; i <= lastIndex; ++i) {
                char character = path.charAt(i);
                if (character != '/' && i != lastIndex) continue;
                if (i == startIndex) {
                    startIndex = i + 1;
                    continue;
                }
                int endIndex = i;
                if (character != '/') {
                    ++endIndex;
                }
                String segment = path.substring(startIndex, endIndex);
                startIndex = i + 1;
                if ((current = current.getChild(segment)) == null) break;
                if (current.servicer == null) continue;
                servicers.add(current.servicer);
            }
        }
    }

    private static class ExactMapper
    implements Mapper {
        private final Map<String, HttpServletServicer> mappings = new HashMap<String, HttpServletServicer>();

        private ExactMapper() {
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public void loadServicer(String mapping, HttpServletServicer servicer) {
            this.mappings.put(mapping, servicer);
        }

        @Override
        public ServicerMapping mapPath(Mapping mapping) {
            HttpServletServicer servicer = this.mappings.get(mapping.getPath());
            if (servicer == null) {
                return null;
            }
            return mapping.createServicerMapping(mapping.getPath(), null, servicer);
        }

        @Override
        public void mapAll(Mapping mapping, List<HttpServletServicer> servicers) {
            HttpServletServicer servicer = this.mappings.get(mapping.getPath());
            if (servicer != null) {
                servicers.add(servicer);
            }
        }
    }

    private static interface Mapper {
        public int getPriority();

        public void loadServicer(String var1, HttpServletServicer var2);

        public ServicerMapping mapPath(Mapping var1);

        public void mapAll(Mapping var1, List<HttpServletServicer> var2);
    }

    private static class Mapping
    implements HttpRequestTokenHandler {
        private String path = "";
        private final Map<String, String[]> parameters = new HashMap<String, String[]>();
        private String queryString = null;

        public Mapping(String expression) throws HttpRequestTokeniseException {
            tokeniser.tokeniseRequestURI(expression, (HttpRequestTokenHandler)this);
        }

        public String getPath() {
            return this.path;
        }

        public ServicerMapping createServicerMapping(String servicerPath, String pathInfo, HttpServletServicer servicer) {
            return new ServicerMappingImpl(servicer, servicerPath, pathInfo, this.queryString, this.parameters);
        }

        public void handlePath(String path) throws HttpRequestTokeniseException {
            this.path = path;
        }

        public void handleHttpParameter(String name, String value) throws HttpRequestTokeniseException {
            String[] values = this.parameters.get(name);
            if (values == null) {
                values = new String[]{value};
            } else {
                String[] appendedValues = new String[values.length + 1];
                System.arraycopy(values, 0, appendedValues, 0, values.length);
                appendedValues[values.length] = value;
                values = appendedValues;
            }
            this.parameters.put(name, values);
        }

        public void handleQueryString(String queryString) throws HttpRequestTokeniseException {
            this.queryString = queryString;
        }

        public void handleFragment(String fragment) throws HttpRequestTokeniseException {
        }
    }
}

