/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.filter.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import net.officefloor.compile.OfficeFloorCompiler;
import net.officefloor.compile.properties.PropertyList;
import net.officefloor.plugin.servlet.context.OfficeServletContext;
import net.officefloor.plugin.servlet.filter.FilterContainerFactory;
import net.officefloor.plugin.servlet.filter.FilterContainerFactoryImpl;
import net.officefloor.plugin.servlet.filter.FilterServicer;
import net.officefloor.plugin.servlet.filter.FilterServicerImpl;
import net.officefloor.plugin.servlet.filter.configuration.FilterInstance;
import net.officefloor.plugin.servlet.filter.configuration.FilterMapping;
import net.officefloor.plugin.servlet.filter.configuration.FilterMappings;
import net.officefloor.plugin.servlet.mapping.MappingType;

public class FilterServicersFactory {
    public FilterServicer[] createFilterServices(Properties properties, ClassLoader classLoader, OfficeServletContext officeServletContext) throws ServletException {
        PropertyList propertyList = this.createPropertyList(properties);
        FilterInstance[] instances = FilterInstance.loadFilterInstances(propertyList);
        HashMap<String, FilterContainerFactoryImpl> factories = new HashMap<String, FilterContainerFactoryImpl>();
        for (FilterInstance instance : instances) {
            Class<?> filterClass;
            String filterName = instance.getName();
            String className = instance.getClassName();
            Map<String, String> initParameters = instance.getInitParameters();
            try {
                filterClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                throw new ServletException((Throwable)ex);
            }
            FilterContainerFactoryImpl factory = new FilterContainerFactoryImpl(filterName, filterClass, initParameters, officeServletContext);
            factories.put(filterName, factory);
        }
        FilterMappings filterMappings = new FilterMappings();
        filterMappings.inputProperties(propertyList);
        FilterMapping[] mappings = filterMappings.getFilterMappings();
        ArrayList<FilterServicerImpl> servicers = new ArrayList<FilterServicerImpl>(mappings.length);
        for (FilterMapping mapping : mappings) {
            String filterName = mapping.getFilterName();
            String urlPattern = mapping.getUrlPattern();
            String servletName = mapping.getServletName();
            MappingType[] mappingTypes = mapping.getMappingTypes();
            FilterContainerFactory factory = (FilterContainerFactory)factories.get(filterName);
            if (factory == null) {
                throw new ServletException("No filter by name '" + filterName + "' configured for filter mapping (url-pattern=" + urlPattern + ", servlet=" + servletName + ")");
            }
            FilterServicerImpl servicer = new FilterServicerImpl(urlPattern, servletName, mappingTypes, factory);
            servicers.add(servicer);
        }
        return servicers.toArray(new FilterServicer[0]);
    }

    private PropertyList createPropertyList(Properties properties) {
        PropertyList propertyList = OfficeFloorCompiler.newPropertyList();
        for (String name : properties.stringPropertyNames()) {
            String value = properties.getProperty(name);
            propertyList.addProperty(name).setValue(value);
        }
        return propertyList;
    }
}

