/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.filter.configuration;

import java.util.LinkedList;
import java.util.List;
import net.officefloor.compile.properties.PropertyList;
import net.officefloor.plugin.servlet.filter.configuration.FilterMapping;
import net.officefloor.plugin.servlet.mapping.MappingType;

public class FilterMappings {
    private final List<FilterMapping> mappings = new LinkedList<FilterMapping>();

    public void addFilterMapping(String filterName, String urlPattern, String servletName, MappingType ... mappingTypes) {
        this.mappings.add(new FilterMapping(filterName, urlPattern, servletName, mappingTypes));
    }

    public FilterMapping[] getFilterMappings() {
        return this.mappings.toArray(new FilterMapping[0]);
    }

    public void outputProperties(PropertyList properties) {
        int index = 0;
        for (FilterMapping mapping : this.mappings) {
            MappingType[] types;
            String servletName;
            String filterName = mapping.getFilterName();
            properties.addProperty("filter.mapping.index." + index).setValue(filterName);
            String urlPattern = mapping.getUrlPattern();
            if (urlPattern != null) {
                properties.addProperty("filter.mapping.url." + index).setValue(urlPattern);
            }
            if ((servletName = mapping.getServletName()) != null) {
                properties.addProperty("filter.mapping.servlet." + index).setValue(servletName);
            }
            if ((types = mapping.getMappingTypes()) != null && types.length > 0) {
                StringBuilder typesValue = new StringBuilder();
                boolean isFirst = true;
                for (MappingType type : types) {
                    if (!isFirst) {
                        typesValue.append(",");
                    }
                    isFirst = false;
                    typesValue.append(type.name());
                }
                properties.addProperty("filter.mapping.type." + index).setValue(typesValue.toString());
            }
            ++index;
        }
    }

    public void inputProperties(PropertyList properties) {
        int index = 0;
        String filterName = properties.getPropertyValue("filter.mapping.index." + index, null);
        while (filterName != null) {
            String urlPattern = properties.getPropertyValue("filter.mapping.url." + index, null);
            String servletName = properties.getPropertyValue("filter.mapping.servlet." + index, null);
            MappingType[] mappingTypes = null;
            String typesValue = properties.getPropertyValue("filter.mapping.type." + index, null);
            if (typesValue != null) {
                String[] typesValues = typesValue.split(",");
                LinkedList<MappingType> types = new LinkedList<MappingType>();
                for (String value : typesValues) {
                    MappingType type = MappingType.valueOf(value);
                    types.add(type);
                }
                mappingTypes = types.toArray(new MappingType[0]);
            }
            this.mappings.add(new FilterMapping(filterName, urlPattern, servletName, mappingTypes));
            filterName = properties.getPropertyValue("filter.mapping.index." + ++index, null);
        }
    }
}

