/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.filter;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import net.officefloor.frame.api.manage.Office;
import net.officefloor.plugin.servlet.context.OfficeServletContext;
import net.officefloor.plugin.servlet.filter.FilterContainer;
import net.officefloor.plugin.servlet.filter.FilterContainerFactory;
import net.officefloor.plugin.servlet.filter.FilterContainerImpl;

public class FilterContainerFactoryImpl
implements FilterContainerFactory {
    private final Map<Office, FilterContainer> containers = new HashMap<Office, FilterContainer>(1);
    private final String filterName;
    private final Class<? extends Filter> filterClass;
    private final Map<String, String> initParameters;
    private final OfficeServletContext officeServletContext;

    public FilterContainerFactoryImpl(String filterName, Class<? extends Filter> filterClass, Map<String, String> initParameters, OfficeServletContext officeServletContext) {
        this.filterName = filterName;
        this.filterClass = filterClass;
        this.initParameters = initParameters;
        this.officeServletContext = officeServletContext;
    }

    @Override
    public synchronized FilterContainer createFilterContainer(Office office) throws ServletException {
        FilterContainer container = this.containers.get(office);
        if (container == null) {
            Filter filter;
            try {
                filter = this.filterClass.newInstance();
            }
            catch (Exception ex) {
                throw new ServletException((Throwable)ex);
            }
            container = new FilterContainerImpl(this.filterName, filter, this.initParameters, this.officeServletContext, office);
            this.containers.put(office, container);
        }
        return container;
    }
}

