/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.filter;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import net.officefloor.frame.api.manage.Office;
import net.officefloor.plugin.servlet.filter.FilterChainFactory;
import net.officefloor.plugin.servlet.filter.FilterChainImpl;
import net.officefloor.plugin.servlet.filter.FilterContainer;
import net.officefloor.plugin.servlet.filter.FilterServicer;
import net.officefloor.plugin.servlet.mapping.MappingType;
import net.officefloor.plugin.servlet.mapping.ServicerMapping;

public class FilterChainFactoryImpl
implements FilterChainFactory {
    private static final String WILD_CARD = "*";
    private static final MappingType[] DEFAULT_MAPPING_TYPES = new MappingType[]{MappingType.REQUEST};
    private final FilterOption[][] filterMappingsByMappingType = new FilterOption[MappingType.values().length][];
    private final FilterOption[][] servletNamesByMappingType = new FilterOption[MappingType.values().length][];

    public FilterChainFactoryImpl(Office office, FilterServicer ... servicers) throws ServletException {
        for (FilterServicer servicer : servicers) {
            FilterOption option;
            String filterMapping;
            FilterContainer filter = servicer.getFilterContainerFactory().createFilterContainer(office);
            String servletName = servicer.getServletName();
            if (servletName != null) {
                ServletNameFilterOption option2 = new ServletNameFilterOption(filter, servletName);
                this.loadFilterOption(option2, servicer, this.servletNamesByMappingType);
            }
            if ((filterMapping = servicer.getFilterMapping()) == null) continue;
            if (filterMapping.endsWith(WILD_CARD)) {
                String pathPrefix = filterMapping.substring(0, filterMapping.length() - WILD_CARD.length());
                option = new PathPrefixFilterOption(filter, pathPrefix);
            } else if (filterMapping.startsWith(WILD_CARD)) {
                String extension = filterMapping.substring(WILD_CARD.length());
                option = new ExtensionFilterOption(filter, extension);
            } else {
                option = new ExactPathFilterOption(filter, filterMapping);
            }
            this.loadFilterOption(option, servicer, this.filterMappingsByMappingType);
        }
    }

    private void loadFilterOption(FilterOption option, FilterServicer servicer, FilterOption[][] options) {
        MappingType[] mappingTypes = servicer.getMappingTypes();
        if (mappingTypes == null || mappingTypes.length == 0) {
            mappingTypes = DEFAULT_MAPPING_TYPES;
        }
        for (MappingType mappingType : mappingTypes) {
            int mappingTypeIndex = mappingType.ordinal();
            FilterOption[] mappingOptions = options[mappingTypeIndex];
            if (mappingOptions == null) {
                mappingOptions = new FilterOption[]{option};
            } else {
                FilterOption[] tmp = new FilterOption[mappingOptions.length + 1];
                System.arraycopy(mappingOptions, 0, tmp, 0, mappingOptions.length);
                tmp[mappingOptions.length] = option;
                mappingOptions = tmp;
            }
            options[mappingTypeIndex] = mappingOptions;
        }
    }

    private FilterChain createFilterChain(String path, String servletName, FilterOption[] options, FilterChain target, Set<FilterContainer> containersUsed) {
        if (options == null) {
            return target;
        }
        for (int i = options.length - 1; i >= 0; --i) {
            FilterOption option = options[i];
            if (!option.isInclude(path, servletName) || containersUsed.contains(option.filter)) continue;
            target = new FilterChainImpl(option.filter, target);
            containersUsed.add(option.filter);
        }
        return target;
    }

    @Override
    public FilterChain createFilterChain(ServicerMapping mapping, MappingType mappingType, FilterChain target) throws ServletException {
        String path = mapping.getServletPath();
        String pathInfo = mapping.getPathInfo();
        if (pathInfo != null) {
            path = path + pathInfo;
        }
        String servletName = mapping.getServicer().getServletName();
        HashSet<FilterContainer> containersUsed = new HashSet<FilterContainer>();
        FilterOption[] options = this.servletNamesByMappingType[mappingType.ordinal()];
        target = this.createFilterChain(path, servletName, options, target, containersUsed);
        options = this.filterMappingsByMappingType[mappingType.ordinal()];
        target = this.createFilterChain(path, servletName, options, target, containersUsed);
        return target;
    }

    private static class ExtensionFilterOption
    extends FilterOption {
        private final String extension;

        public ExtensionFilterOption(FilterContainer filter, String extension) {
            super(filter);
            this.extension = extension;
        }

        @Override
        public boolean isInclude(String path, String servletName) {
            return path.endsWith(this.extension);
        }
    }

    private static class PathPrefixFilterOption
    extends FilterOption {
        private final String pathPrefix;

        public PathPrefixFilterOption(FilterContainer filter, String pathPrefix) {
            super(filter);
            String PATH_SEPARATOR = "/";
            while (pathPrefix.endsWith("/")) {
                pathPrefix = pathPrefix.substring(0, pathPrefix.length() - "/".length());
            }
            this.pathPrefix = pathPrefix;
        }

        @Override
        public boolean isInclude(String path, String servletName) {
            return path.startsWith(this.pathPrefix);
        }
    }

    private static class ExactPathFilterOption
    extends FilterOption {
        private final String exactPath;

        public ExactPathFilterOption(FilterContainer filter, String exactPath) {
            super(filter);
            this.exactPath = exactPath;
        }

        @Override
        public boolean isInclude(String path, String servletName) {
            return this.exactPath.equals(path);
        }
    }

    private static class ServletNameFilterOption
    extends FilterOption {
        private final String servletName;

        public ServletNameFilterOption(FilterContainer filter, String servletName) {
            super(filter);
            this.servletName = servletName;
        }

        @Override
        public boolean isInclude(String path, String servletName) {
            return this.servletName.equals(servletName);
        }
    }

    private static abstract class FilterOption {
        public final FilterContainer filter;

        public FilterOption(FilterContainer filter) {
            this.filter = filter;
        }

        public abstract boolean isInclude(String var1, String var2);
    }
}

