/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.webxml.model;

import java.util.LinkedList;
import java.util.List;
import net.officefloor.model.AbstractModel;
import net.officefloor.model.ItemModel;
import net.officefloor.model.Model;
import net.officefloor.model.RemoveConnectionsAction;
import net.officefloor.plugin.servlet.webxml.model.InitParamModel;

public class ServletModel
extends AbstractModel
implements ItemModel<ServletModel> {
    private String servletName;
    private String servletClass;
    private List<InitParamModel> initParam = new LinkedList<InitParamModel>();

    public ServletModel() {
    }

    public ServletModel(String servletName, String servletClass) {
        this.servletName = servletName;
        this.servletClass = servletClass;
    }

    public ServletModel(String servletName, String servletClass, InitParamModel[] initParam) {
        this.servletName = servletName;
        this.servletClass = servletClass;
        if (initParam != null) {
            for (InitParamModel model : initParam) {
                this.initParam.add(model);
            }
        }
    }

    public ServletModel(String servletName, String servletClass, InitParamModel[] initParam, int x, int y) {
        this.servletName = servletName;
        this.servletClass = servletClass;
        if (initParam != null) {
            for (InitParamModel model : initParam) {
                this.initParam.add(model);
            }
        }
        this.setX(x);
        this.setY(y);
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        String oldValue = this.servletName;
        this.servletName = servletName;
        this.changeField(oldValue, this.servletName, ServletEvent.CHANGE_SERVLET_NAME);
    }

    public String getServletClass() {
        return this.servletClass;
    }

    public void setServletClass(String servletClass) {
        String oldValue = this.servletClass;
        this.servletClass = servletClass;
        this.changeField(oldValue, this.servletClass, ServletEvent.CHANGE_SERVLET_CLASS);
    }

    public List<InitParamModel> getInitParams() {
        return this.initParam;
    }

    public void addInitParam(InitParamModel initParam) {
        this.addItemToList((Object)initParam, this.initParam, ServletEvent.ADD_INIT_PARAM);
    }

    public void removeInitParam(InitParamModel initParam) {
        this.removeItemFromList((Object)initParam, this.initParam, ServletEvent.REMOVE_INIT_PARAM);
    }

    public RemoveConnectionsAction<ServletModel> removeConnections() {
        RemoveConnectionsAction _action = new RemoveConnectionsAction((Model)this);
        return _action;
    }

    public static enum ServletEvent {
        CHANGE_SERVLET_NAME,
        CHANGE_SERVLET_CLASS,
        ADD_INIT_PARAM,
        REMOVE_INIT_PARAM;

    }
}

