/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.officefloor.plugin.servlet.resource.ResourceLocator;

public class FileSystemResourceLocator
implements ResourceLocator {
    private final File root;

    public FileSystemResourceLocator(File root) {
        this.root = root;
    }

    @Override
    public URL getResource(String resourcePath) throws MalformedURLException {
        File file = new File(this.root, resourcePath);
        if (!file.exists()) {
            return null;
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.toURI().toURL();
    }

    @Override
    public InputStream getResourceAsStream(String resourcePath) {
        File file = new File(this.root, resourcePath);
        if (!file.exists()) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }

    @Override
    public Set<String> getResourceChildren(String resourcePath) {
        File directory = new File(this.root, resourcePath);
        if (!directory.isDirectory()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(directory.list()));
    }
}

