/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.container;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.officefloor.plugin.servlet.container.HttpResponsePrintWriter;
import net.officefloor.plugin.servlet.container.HttpResponseServletOutputStream;
import net.officefloor.plugin.servlet.time.Clock;
import net.officefloor.plugin.socket.server.http.HttpHeader;
import net.officefloor.plugin.socket.server.http.HttpResponse;
import net.officefloor.plugin.web.http.cookie.HttpCookie;
import net.officefloor.plugin.web.http.cookie.HttpCookieUtil;

public class HttpServletResponseImpl
implements HttpServletResponse {
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private static final Pattern EXTRACT_CHARSET_PATTERN;
    private static final DateFormat DATE_HEADER_FORMATTER;
    private final HttpResponse response;
    private final HttpResponseServletOutputStream outputStream;
    private final Clock clock;
    private final HttpServletRequest request;
    private Locale locale;
    private boolean isOutputStreamRetrieved = false;
    private boolean isPrintWriterRetrieved = false;
    private Charset characterEncoding = Charset.forName("ISO-8859-1");

    public HttpServletResponseImpl(HttpResponse response, Clock clock, HttpServletRequest request, Locale locale) {
        this.response = response;
        this.outputStream = new HttpResponseServletOutputStream(this.response.getBody().getOutputStream());
        this.clock = clock;
        this.request = request;
        this.locale = locale;
    }

    void flushBuffers() throws IOException {
        this.outputStream.flush();
    }

    public void setStatus(int sc) {
        this.response.setStatus(sc);
    }

    public void setBufferSize(int size) {
        try {
            this.outputStream.setBufferSize(size);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public int getBufferSize() {
        return this.outputStream.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.outputStream.flush();
    }

    public void resetBuffer() {
        this.outputStream.reset();
    }

    public boolean isCommitted() {
        return this.outputStream.isCommitted();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.isPrintWriterRetrieved) {
            throw new IllegalStateException("PrintWriter has already been retrieved");
        }
        this.isOutputStreamRetrieved = true;
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.isOutputStreamRetrieved) {
            throw new IllegalStateException("OutputStream has already been retrieved");
        }
        this.isPrintWriterRetrieved = true;
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)this.outputStream), this.characterEncoding);
        return new HttpResponsePrintWriter((Writer)writer, this.outputStream);
    }

    public void reset() {
        this.resetBuffer();
        for (HttpHeader header : this.response.getHeaders()) {
            this.response.removeHeader(header);
        }
    }

    public void setContentLength(int len) {
        this.response.removeHeaders(CONTENT_LENGTH);
        this.response.addHeader(CONTENT_LENGTH, String.valueOf(len));
    }

    public void setContentType(String type) {
        if (this.isPrintWriterRetrieved) {
            throw new IllegalStateException("PrintWriter has already been retrieved");
        }
        this.response.removeHeaders(CONTENT_TYPE);
        this.response.addHeader(CONTENT_TYPE, type);
        Matcher matcher = EXTRACT_CHARSET_PATTERN.matcher(type);
        if (matcher.matches()) {
            String charsetName = matcher.group(1);
            this.setCharacterEncoding(charsetName.trim());
        }
    }

    public String getContentType() {
        HttpHeader header = this.response.getHeader(CONTENT_TYPE);
        return header == null ? null : header.getValue();
    }

    public void setCharacterEncoding(String charset) {
        if (this.isPrintWriterRetrieved) {
            throw new IllegalStateException("PrintWriter has already been retrieved");
        }
        this.characterEncoding = Charset.forName(charset);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding.displayName();
    }

    public void addCookie(Cookie cookie) {
        int maxAge;
        HttpCookie httpCookie = new HttpCookie(cookie.getName(), cookie.getValue());
        String domain = cookie.getDomain();
        if (domain != null) {
            httpCookie.setDomain(domain);
        }
        if ((maxAge = cookie.getMaxAge()) > 0) {
            long expireTime = this.clock.currentTimeMillis() + (long)maxAge;
            httpCookie.setExpires(expireTime);
        }
        HttpCookieUtil.addHttpCookie((HttpCookie)httpCookie, (HttpResponse)this.response);
    }

    public boolean containsHeader(String name) {
        for (HttpHeader header : this.response.getHeaders()) {
            if (!header.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.response.removeHeaders(name);
        this.addHeader(name, value);
    }

    public void addDateHeader(String name, long date) {
        this.response.addHeader(name, DATE_HEADER_FORMATTER.format(new Date(date)));
    }

    public void setDateHeader(String name, long date) {
        this.response.removeHeaders(name);
        this.addDateHeader(name, date);
    }

    public void addIntHeader(String name, int value) {
        this.response.addHeader(name, String.valueOf(value));
    }

    public void setIntHeader(String name, int value) {
        this.response.removeHeaders(name);
        this.addIntHeader(name, value);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public void sendError(int sc, String msg) throws IOException {
        this.response.setStatus(sc, msg);
        PrintWriter writer = this.getWriter();
        writer.print("<html><body>");
        writer.print(msg);
        writer.write("</body></html>");
        writer.flush();
        this.response.send();
    }

    public void sendError(int sc) throws IOException {
        this.response.setStatus(sc);
        this.response.send();
    }

    public void sendRedirect(String location) throws IOException {
        String redirectUrl = this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getServerPort() + this.request.getContextPath() + (location.startsWith("/") ? location : this.request.getServletPath() + "/" + location);
        this.response.setStatus(307);
        this.response.addHeader("Location", redirectUrl);
        this.response.send();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public String encodeRedirectUrl(String url) {
        throw new UnsupportedOperationException("HttpServletResponse.encodeRedirectUrl deprecated as of version 2.1");
    }

    public String encodeUrl(String url) {
        throw new UnsupportedOperationException("HttpServletResponse.encodeUrl deprecated as of version 2.1");
    }

    public void setStatus(int sc, String sm) {
        throw new UnsupportedOperationException("HttpServletResponse.setStatus deprecated as of version 2.1");
    }

    static {
        String extractCharsetRegExp = ".*;\\s*charset\\s*=\\s*([^;]+).*";
        EXTRACT_CHARSET_PATTERN = Pattern.compile(".*;\\s*charset\\s*=\\s*([^;]+).*", 2);
        DATE_HEADER_FORMATTER = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        DATE_HEADER_FORMATTER.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

