/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.stream.inputstream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.officefloor.plugin.stream.BufferProcessor;
import net.officefloor.plugin.stream.GatheringBufferProcessor;
import net.officefloor.plugin.stream.InputBufferStream;
import net.officefloor.plugin.stream.OutputBufferStream;
import net.officefloor.plugin.stream.inputstream.BrowsableInputStream;
import net.officefloor.plugin.stream.synchronise.SynchronizedInputStream;

public class InputStreamInputBufferStream
implements InputBufferStream {
    private BrowsableInputStream browsableInput = null;
    private SynchronizedInputStream synchronizedInput = null;

    public InputStreamInputBufferStream(InputStream input) {
        this.browsableInput = new BrowsableInputStream(input, 1024, this);
        this.synchronizedInput = new SynchronizedInputStream((InputStream)this.browsableInput, (Object)this);
    }

    public InputStream getInputStream() {
        return this.synchronizedInput;
    }

    public InputStream getBrowseStream() {
        return new SynchronizedInputStream(this.browsableInput.createBrowser(), (Object)this);
    }

    public int read(byte[] readBuffer) throws IOException {
        return this.synchronizedInput.read(readBuffer);
    }

    public int read(byte[] readBuffer, int offset, int length) throws IOException {
        return this.synchronizedInput.read(readBuffer, offset, length);
    }

    public int read(BufferProcessor processor) throws IOException {
        int available = this.synchronizedInput.available();
        byte[] data = new byte[available];
        this.synchronizedInput.read(data);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        processor.process(buffer);
        return data.length;
    }

    public int read(int numberOfBytes, GatheringBufferProcessor processor) throws IOException {
        byte[] data = new byte[numberOfBytes];
        int bytesRead = this.synchronizedInput.read(data);
        ByteBuffer buffer = ByteBuffer.wrap(data, 0, bytesRead);
        processor.process(new ByteBuffer[]{buffer});
        return bytesRead;
    }

    public int read(int numberOfBytes, OutputBufferStream outputBufferStream) throws IOException {
        int bytesRead;
        OutputStream output = outputBufferStream.getOutputStream();
        for (bytesRead = 0; bytesRead < numberOfBytes; ++bytesRead) {
            int value = this.synchronizedInput.read();
            if (value == -1) {
                return bytesRead;
            }
            output.write(value);
        }
        return bytesRead;
    }

    public long skip(long numberOfBytes) throws IOException {
        return this.synchronizedInput.skip(numberOfBytes);
    }

    public long available() throws IOException {
        return this.synchronizedInput.available();
    }

    public void close() throws IOException {
        this.synchronizedInput.close();
    }
}

