/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.host.source;

import net.officefloor.frame.api.build.None;
import net.officefloor.frame.spi.managedobject.ManagedObject;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectSourceContext;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractAsyncManagedObjectSource;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractManagedObjectSource;
import net.officefloor.plugin.servlet.host.ServletServer;
import net.officefloor.plugin.servlet.host.ServletServerImpl;
import net.officefloor.plugin.servlet.log.StdoutLogger;
import net.officefloor.plugin.servlet.resource.ClassPathResourceLocator;

public class ServletServerManagedObjectSource
extends AbstractManagedObjectSource<None, None>
implements ManagedObject {
    public static final String PROPERTY_SERVER_NAME = "server.name";
    public static final String PROPERTY_SERVER_PORT = "server.port";
    public static final String PROPERTY_CONTEXT_PATH = "context.path";
    public static final String PROPERTY_CLASS_PATH_PREFIX = "class.path.prefix";
    public static final String DEFAULT_CLASS_PATH_PREFIX = "WEB-PUBLIC";
    private ServletServer servletServer;

    protected void loadSpecification(AbstractAsyncManagedObjectSource.SpecificationContext context) {
        context.addProperty(PROPERTY_SERVER_NAME, "Server Name");
        context.addProperty(PROPERTY_SERVER_PORT, "Server Port");
        context.addProperty(PROPERTY_CONTEXT_PATH, "Context Path");
    }

    protected void loadMetaData(AbstractAsyncManagedObjectSource.MetaDataContext<None, None> context) throws Exception {
        ManagedObjectSourceContext mosContext = context.getManagedObjectSourceContext();
        String serverName = mosContext.getProperty(PROPERTY_SERVER_NAME);
        int serverPort = Integer.parseInt(mosContext.getProperty(PROPERTY_SERVER_PORT, "80"));
        String contextPath = mosContext.getProperty(PROPERTY_CONTEXT_PATH);
        String classPathPrefix = mosContext.getProperty(PROPERTY_CLASS_PATH_PREFIX, DEFAULT_CLASS_PATH_PREFIX);
        ClassPathResourceLocator resourceLocator = new ClassPathResourceLocator(classPathPrefix, new String[0]);
        StdoutLogger logger = new StdoutLogger();
        this.servletServer = new ServletServerImpl(serverName, serverPort, contextPath, resourceLocator, logger);
        context.setObjectClass(ServletServer.class);
    }

    protected ManagedObject getManagedObject() throws Throwable {
        return this;
    }

    public Object getObject() throws Throwable {
        return this.servletServer;
    }
}

