/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet;

import java.io.FileNotFoundException;
import java.io.InputStream;
import net.officefloor.model.impl.repository.ModelRepositoryImpl;
import net.officefloor.model.impl.repository.classloader.ClassLoaderConfigurationContext;
import net.officefloor.model.repository.ConfigurationContext;
import net.officefloor.model.repository.ModelRepository;
import net.officefloor.model.woof.WoofRepository;
import net.officefloor.model.woof.WoofRepositoryImpl;
import net.officefloor.plugin.servlet.OfficeFloorServletFilter;
import net.officefloor.plugin.web.http.application.WebAutoWireApplication;
import net.officefloor.plugin.woof.WoofLoaderImpl;

public class WoofServletFilter
extends OfficeFloorServletFilter {
    public static final String DEFAULT_WOOF_CONFIGUARTION_LOCATION = "application.woof";
    public static final String PROPERTY_WOOF_CONFIGURATION_LOCATION = "woof.configuration.location";

    @Override
    protected void configure() throws Exception {
        InputStream available;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String location = this.getFilterConfig().getInitParameter(PROPERTY_WOOF_CONFIGURATION_LOCATION);
        if (location == null || location.trim().length() == 0) {
            location = DEFAULT_WOOF_CONFIGUARTION_LOCATION;
        }
        if ((available = classLoader.getResourceAsStream(location)) == null) {
            throw new FileNotFoundException("Can not find WoOF configuration at " + location);
        }
        available.close();
        ClassLoaderConfigurationContext context = new ClassLoaderConfigurationContext(classLoader);
        WoofRepositoryImpl repository = new WoofRepositoryImpl((ModelRepository)new ModelRepositoryImpl());
        WoofLoaderImpl woofLoader = new WoofLoaderImpl(classLoader, (ConfigurationContext)context, (WoofRepository)repository);
        woofLoader.loadWoofConfiguration(location, (WebAutoWireApplication)this);
    }
}

